/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyClientProvider;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Certificates;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

public final class ProxyHandler
implements HttpHandler {
    private final ProxyClientProvider clientProvider;
    private final int maxRequestTime;
    private static final AttachmentKey<ClientConnection> CONNECTION = AttachmentKey.create(ClientConnection.class);
    private static final AttachmentKey<HttpServerExchange> EXCHANGE = AttachmentKey.create(HttpServerExchange.class);
    private static final AttachmentKey<XnioExecutor.Key> TIMEOUT_KEY = AttachmentKey.create(XnioExecutor.Key.class);
    private final ProxyClientHandler proxyClientHandler = new ProxyClientHandler();
    private final ProxyClientProviderHandler proxyClientProviderHandler = new ProxyClientProviderHandler();
    private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();

    public ProxyHandler(ProxyClientProvider clientProvider, int maxRequestTime) {
        this.clientProvider = clientProvider;
        this.maxRequestTime = maxRequestTime;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        if (this.maxRequestTime > 0) {
            final XnioExecutor.Key key = exchange.getIoThread().executeAfter(new Runnable(){

                @Override
                public void run() {
                    UndertowLogger.REQUEST_LOGGER.proxyRequestTimedOut(exchange.getRequestURI());
                    IoUtils.safeClose((Closeable)exchange.getConnection());
                    ClientConnection clientConnection = (ClientConnection)exchange.getAttachment(CONNECTION);
                    IoUtils.safeClose((Closeable)clientConnection);
                }
            }, this.maxRequestTime, TimeUnit.MILLISECONDS);
            exchange.putAttachment(TIMEOUT_KEY, key);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    key.remove();
                    nextListener.proceed();
                }
            });
        }
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                ProxyHandler.this.clientProvider.createProxyClient(exchange, ProxyHandler.this.proxyClientProviderHandler, -1L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public ProxyHandler addRequestHeader(HttpString header, ExchangeAttribute attribute) {
        this.requestHeaders.put(header, attribute);
        return this;
    }

    public ProxyHandler addRequestHeader(HttpString header, String attribute, ClassLoader classLoader) {
        this.requestHeaders.put(header, ExchangeAttributes.parser(classLoader).parse(attribute));
        return this;
    }

    public ProxyHandler removeRequestHeader(HttpString header) {
        this.requestHeaders.remove(header);
        return this;
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            to.putAll(values.getHeaderName(), values);
            f = from.fiNextNonEmpty(f);
        }
    }

    private static final class IoExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final HttpServerExchange exchange;
        private final ClientConnection clientConnection;

        private IoExceptionHandler(HttpServerExchange exchange, ClientConnection clientConnection) {
            this.exchange = exchange;
            this.clientConnection = clientConnection;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)this.clientConnection);
            UndertowLogger.REQUEST_IO_LOGGER.debug("Exception reading from target server", exception);
            if (!this.exchange.isResponseStarted()) {
                this.exchange.setResponseCode(500);
            }
            this.exchange.setPersistent(false);
            this.exchange.endExchange();
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;

        private HTTPTrailerChannelListener(Attachable source, Attachable target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(ChunkedStreamSourceConduit.TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(ChunkedStreamSinkConduit.TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            channel.suspendWrites();
                            channel.getWriteSetter().set(null);
                        }
                    }, ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                } else {
                    channel.getWriteSetter().set(null);
                    channel.shutdownWrites();
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    private static final class ResponseCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange exchange;

        private ResponseCallback(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void completed(final ClientExchange result) {
            HttpServerExchange exchange = (HttpServerExchange)result.getAttachment(EXCHANGE);
            ClientResponse response = result.getResponse();
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = exchange.getResponseHeaders();
            exchange.setResponseCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (exchange.isUpgrade()) {
                exchange.upgradeChannel(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        StreamConnection clientChannel = null;
                        HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
                        try {
                            clientChannel = result.getConnection().performUpgrade();
                            connection.resetChannel();
                            StreamConnection streamConnection = connection.getChannel();
                            if (connection.getExtraBytes() != null) {
                                streamConnection.getSourceChannel().setConduit(new ReadDataStreamSourceConduit(streamConnection.getSourceChannel().getConduit(), connection));
                            }
                            ChannelListeners.initiateTransfer(Long.MAX_VALUE, clientChannel.getSourceChannel(), streamConnection.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), connection.getBufferPool());
                            ChannelListeners.initiateTransfer(Long.MAX_VALUE, streamConnection.getSourceChannel(), clientChannel.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), connection.getBufferPool());
                            nextListener.proceed();
                        }
                        catch (IOException e) {
                            IoUtils.safeClose((Closeable)connection.getChannel());
                        }
                    }
                });
            }
            IoExceptionHandler handler = new IoExceptionHandler(exchange, result.getConnection());
            ChannelListeners.initiateTransfer(Long.MAX_VALUE, result.getResponseChannel(), exchange.getResponseChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(result, exchange), handler, handler, exchange.getConnection().getBufferPool());
        }

        @Override
        public void failed(IOException e) {
            this.exchange.setResponseCode(500);
            this.exchange.endExchange();
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final ClientConnection clientConnection;
        private final HttpServerExchange exchange;
        private final Map<HttpString, ExchangeAttribute> requestHeaders;

        public ProxyAction(ClientConnection clientConnection, HttpServerExchange exchange, Map<HttpString, ExchangeAttribute> requestHeaders) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.requestHeaders = requestHeaders;
        }

        @Override
        public void run() {
            ClientRequest request = new ClientRequest();
            String requestURI = this.exchange.getRequestURI();
            String qs = this.exchange.getQueryString();
            if (qs != null && !qs.isEmpty()) {
                requestURI = requestURI + "?" + qs;
            }
            request.setPath(requestURI).setMethod(this.exchange.getRequestMethod());
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            for (Map.Entry<HttpString, ExchangeAttribute> entry : this.requestHeaders.entrySet()) {
                String headerValue = entry.getValue().readAttribute(this.exchange);
                if (headerValue == null || headerValue.isEmpty()) {
                    outboundRequestHeaders.remove(entry.getKey());
                    continue;
                }
                outboundRequestHeaders.put(entry.getKey(), headerValue.replace('\n', ' '));
            }
            SocketAddress address = this.exchange.getConnection().getPeerAddress();
            if (address instanceof InetSocketAddress) {
                outboundRequestHeaders.put(Headers.X_FORWARDED_FOR, ((InetSocketAddress)address).getAddress().getHostAddress());
            } else {
                outboundRequestHeaders.put(Headers.X_FORWARDED_FOR, "localhost");
            }
            SSLSessionInfo sslSessionInfo = this.exchange.getConnection().getSslSessionInfo();
            if (sslSessionInfo != null) {
                request.putAttachment(ProxiedRequestAttachments.IS_SSL, true);
                try {
                    X509Certificate[] peerCertificates = sslSessionInfo.getPeerCertificateChain();
                    if (peerCertificates.length > 0) {
                        request.putAttachment(ProxiedRequestAttachments.SSL_CERT, Certificates.toPem(peerCertificates[0]));
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                }
                catch (CertificateEncodingException e) {
                    // empty catch block
                }
                request.putAttachment(ProxiedRequestAttachments.SSL_CYPHER, sslSessionInfo.getCipherSuite());
                request.putAttachment(ProxiedRequestAttachments.SSL_SESSION_ID, sslSessionInfo.getSessionId());
            }
            this.clientConnection.sendRequest(request, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(ClientExchange result) {
                    result.putAttachment(EXCHANGE, ProxyAction.this.exchange);
                    if (HttpContinue.requiresContinueResponse(ProxyAction.this.exchange)) {
                        result.setContinueHandler(new ContinueNotification(){

                            @Override
                            public void handleContinue(ClientExchange clientExchange) {
                                HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                                    @Override
                                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                                    }

                                    @Override
                                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                        IoUtils.safeClose((Closeable)ProxyAction.this.clientConnection);
                                    }
                                });
                            }
                        });
                    }
                    result.setResponseListener(new ResponseCallback(ProxyAction.this.exchange));
                    IoExceptionHandler handler = new IoExceptionHandler(ProxyAction.this.exchange, ProxyAction.this.clientConnection);
                    ChannelListeners.initiateTransfer(Long.MAX_VALUE, ProxyAction.this.exchange.getRequestChannel(), result.getRequestChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(ProxyAction.this.exchange, result), handler, handler, ProxyAction.this.exchange.getConnection().getBufferPool());
                }

                @Override
                public void failed(IOException e) {
                    ProxyAction.this.exchange.setResponseCode(500);
                    ProxyAction.this.exchange.setPersistent(false);
                    ProxyAction.this.exchange.endExchange();
                }
            });
        }
    }

    private final class ProxyClientHandler
    implements ProxyCallback<ClientConnection> {
        private ProxyClientHandler() {
        }

        @Override
        public void completed(HttpServerExchange exchange, ClientConnection result) {
            exchange.putAttachment(CONNECTION, result);
            exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(result, exchange, ProxyHandler.this.requestHeaders));
        }

        @Override
        public void failed(HttpServerExchange exchange) {
            exchange.setResponseCode(500);
            exchange.endExchange();
        }
    }

    private final class ProxyClientProviderHandler
    implements ProxyCallback<ProxyClient> {
        private ProxyClientProviderHandler() {
        }

        @Override
        public void completed(HttpServerExchange exchange, ProxyClient result) {
            result.getConnection(exchange, ProxyHandler.this.proxyClientHandler, -1L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void failed(HttpServerExchange exchange) {
            exchange.setResponseCode(500);
            exchange.endExchange();
        }
    }
}

