/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class DetachableStreamSinkChannel
implements StreamSinkChannel {
    protected final StreamSinkChannel delegate;
    protected final ChannelListener.SimpleSetter<DetachableStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<DetachableStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();

    public DetachableStreamSinkChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
        delegate.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                if (DetachableStreamSinkChannel.this.isFinished()) {
                    channel.suspendWrites();
                    return;
                }
                ChannelListener<DetachableStreamSinkChannel> listener = DetachableStreamSinkChannel.this.writeSetter.get();
                if (listener == null) {
                    channel.suspendWrites();
                    return;
                }
                listener.handleEvent(DetachableStreamSinkChannel.this);
            }
        });
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener(this, this.closeSetter));
    }

    protected abstract boolean isFinished();

    @Override
    public void suspendWrites() {
        if (this.isFinished()) {
            return;
        }
        this.delegate.suspendWrites();
    }

    @Override
    public boolean isWriteResumed() {
        if (this.isFinished()) {
            return false;
        }
        return this.delegate.isWriteResumed();
    }

    @Override
    public void shutdownWrites() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.delegate.shutdownWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        this.delegate.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        this.delegate.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public boolean isOpen() {
        return !this.isFinished() && this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.delegate.close();
    }

    @Override
    public boolean flush() throws IOException {
        if (this.isFinished()) {
            return true;
        }
        return this.delegate.flush();
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.write(srcs);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.setOption(option, value);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.write(src);
    }

    @Override
    public void resumeWrites() {
        if (this.isFinished()) {
            return;
        }
        this.delegate.resumeWrites();
    }

    @Override
    public void wakeupWrites() {
        if (this.isFinished()) {
            return;
        }
        this.delegate.wakeupWrites();
    }

    public void responseDone() {
        this.delegate.getCloseSetter().set(null);
        this.delegate.getWriteSetter().set(null);
        if (this.delegate.isWriteResumed()) {
            this.delegate.suspendWrites();
        }
    }
}

