/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.spec.WebConnectionImpl;
import javax.servlet.http.HttpUpgradeHandler;
import org.xnio.StreamConnection;

public class ServletUpgradeListener<T extends HttpUpgradeHandler>
implements ExchangeCompletionListener {
    private final InstanceHandle<T> instance;

    public ServletUpgradeListener(InstanceHandle<T> instance) {
        this.instance = instance;
    }

    @Override
    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        final StreamConnection channel = exchange.getConnection().upgradeChannel();
        exchange.getConnection().addCloseListener(new ServerConnection.CloseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closed(ServerConnection connection) {
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).destroy();
                }
                finally {
                    ServletUpgradeListener.this.instance.release();
                }
            }
        });
        exchange.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).init(new WebConnectionImpl(channel));
            }
        });
    }
}

