/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.UndertowMessages;
import io.undertow.websockets.core.FragmentedMessageChannel;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.Pool;
import org.xnio.Pooled;

public final class BinaryOutputStream
extends OutputStream {
    private final FragmentedMessageChannel sender;
    private final Pooled<ByteBuffer> pooled;
    private boolean closed;

    public BinaryOutputStream(FragmentedMessageChannel sender, Pool<ByteBuffer> pool) {
        this.sender = sender;
        this.pooled = pool.allocate();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = this.pooled.getResource();
        int remaining = buffer.remaining();
        if (remaining >= len) {
            buffer.put(b, off, len);
            this.send(false, false);
        } else {
            int toWrite;
            int left = len;
            do {
                toWrite = Math.min(remaining, left);
                buffer.put(b, off, toWrite);
                off += toWrite;
                this.send(false, false);
                remaining = buffer.remaining();
            } while ((left -= toWrite) > 0);
        }
    }

    private void send(boolean force, boolean last) throws IOException {
        ByteBuffer buffer = this.pooled.getResource();
        if (force || !buffer.hasRemaining()) {
            buffer.flip();
            StreamSinkFrameChannel channel = this.sender.send(buffer.remaining(), last);
            while (buffer.hasRemaining()) {
                int res = channel.write(buffer);
                if (res != 0) continue;
                channel.awaitWritable();
            }
            channel.shutdownWrites();
            while (!channel.flush()) {
                channel.awaitWritable();
            }
            buffer.clear();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = this.pooled.getResource();
        buffer.put((byte)b);
        this.send(false, false);
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.send(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.closed = true;
                this.send(true, true);
            }
            finally {
                this.pooled.free();
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
    }
}

