/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketHandshakeException;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.spi.UpgradeCallback;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.regex.Pattern;
import org.xnio.IoFuture;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public abstract class Handshake {
    private final WebSocketVersion version;
    private final String hashAlgorithm;
    private final String magicNumber;
    protected final Set<String> subprotocols;
    private static final byte[] EMPTY = new byte[0];
    private static final Pattern PATTERN = Pattern.compile(",");

    protected Handshake(WebSocketVersion version, String hashAlgorithm, String magicNumber, Set<String> subprotocols) {
        this.version = version;
        this.hashAlgorithm = hashAlgorithm;
        this.magicNumber = magicNumber;
        this.subprotocols = subprotocols;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getMagicNumber() {
        return this.magicNumber;
    }

    protected static String getWebSocketLocation(WebSocketHttpExchange exchange) {
        String scheme = "https".equals(exchange.getRequestScheme()) ? "wss" : "ws";
        return scheme + "://" + exchange.getRequestHeader("Host") + exchange.getRequestURI();
    }

    public final void handshake(final WebSocketHttpExchange exchange, final WebSocketConnectionCallback callback) {
        exchange.upgradeChannel(new UpgradeCallback(){

            @Override
            public void handleUpgrade(StreamConnection channel, Pool<ByteBuffer> buffers) {
                WebSocketChannel webSocket = Handshake.this.createChannel(exchange, channel, buffers);
                callback.onConnect(exchange, webSocket);
            }
        });
        this.handshakeInternal(exchange);
    }

    protected abstract void handshakeInternal(WebSocketHttpExchange var1);

    public abstract boolean matches(WebSocketHttpExchange var1);

    public abstract WebSocketChannel createChannel(WebSocketHttpExchange var1, StreamConnection var2, Pool<ByteBuffer> var3);

    protected final void performUpgrade(WebSocketHttpExchange exchange, byte[] data) {
        exchange.setResponseHeader("Content-Length", String.valueOf(data.length));
        exchange.setResponseHeader("Upgrade", "WebSocket");
        exchange.setResponseHeader("Connection", "Upgrade");
        this.upgradeChannel(exchange, data);
    }

    protected void upgradeChannel(WebSocketHttpExchange exchange, byte[] data) {
        if (data.length > 0) {
            Handshake.writePayload(exchange, ByteBuffer.wrap(data));
        } else {
            exchange.endExchange();
        }
    }

    private static void writePayload(final WebSocketHttpExchange exchange, ByteBuffer payload) {
        exchange.sendData(payload).addNotifier(new IoFuture.Notifier<Void, Object>(){

            @Override
            public void notify(IoFuture<? extends Void> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.DONE) {
                    exchange.endExchange();
                } else {
                    exchange.close();
                }
            }
        }, null);
    }

    protected final void performUpgrade(WebSocketHttpExchange exchange) {
        this.performUpgrade(exchange, EMPTY);
    }

    protected final void selectSubprotocol(WebSocketHttpExchange exchange) throws WebSocketHandshakeException {
        String requestedSubprotocols = exchange.getRequestHeader("Sec-WebSocket-Protocol");
        if (requestedSubprotocols == null) {
            return;
        }
        String[] requestedSubprotocolArray = PATTERN.split(requestedSubprotocols);
        String subProtocol = this.supportedSubprotols(requestedSubprotocolArray);
        if (subProtocol == null) {
            throw WebSocketMessages.MESSAGES.unsupportedProtocol(requestedSubprotocols, this.subprotocols);
        }
        exchange.setResponseHeader("Sec-WebSocket-Protocol", subProtocol);
    }

    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        for (String p : requestedSubprotocolArray) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!requestedSubprotocol.equals(supportedSubprotocol)) continue;
                return supportedSubprotocol;
            }
        }
        return null;
    }
}

