/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.DateUtils;

public class Cookies {
    public static Cookie parseSetCookieHeader(String headerValue) {
        String key = null;
        CookieImpl cookie = null;
        int state = 0;
        int current = 0;
        block5: for (int i = 0; i < headerValue.length(); ++i) {
            char c = headerValue.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '=') {
                        key = headerValue.substring(current, i);
                        current = i + 1;
                        state = 1;
                        continue block5;
                    }
                    if ((c == ';' || c == ' ') && current == i) {
                        ++current;
                        continue block5;
                    }
                    if (c != ';') continue block5;
                    if (cookie == null) {
                        throw UndertowMessages.MESSAGES.couldNotParseCookie(headerValue);
                    }
                    Cookies.handleValue(cookie, headerValue.substring(current, i), null);
                    current = i + 1;
                    continue block5;
                }
                case 1: {
                    if (c == ';') {
                        if (cookie == null) {
                            cookie = new CookieImpl(key, headerValue.substring(current, i));
                        } else {
                            Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                        }
                        state = 0;
                        current = i + 1;
                        key = null;
                        continue block5;
                    }
                    if (c != '\"' || current != i) continue block5;
                    ++current;
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (c != '\"') continue block5;
                    if (cookie == null) {
                        cookie = new CookieImpl(key, headerValue.substring(current, i));
                    } else {
                        Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                    }
                    state = 0;
                    current = i + 1;
                    key = null;
                }
            }
        }
        if (key == null) {
            if (current != headerValue.length()) {
                Cookies.handleValue(cookie, headerValue.substring(current, headerValue.length()), null);
            }
        } else if (current != headerValue.length()) {
            Cookies.handleValue(cookie, key, headerValue.substring(current, headerValue.length()));
        } else {
            Cookies.handleValue(cookie, key, null);
        }
        return cookie;
    }

    private static void handleValue(CookieImpl cookie, String key, String value) {
        if (key.toLowerCase().equals("path")) {
            cookie.setPath(value);
        } else if (key.toLowerCase().equals("domain")) {
            cookie.setDomain(value);
        } else if (key.toLowerCase().equals("max-age")) {
            cookie.setMaxAge(Integer.parseInt(value));
        } else if (key.toLowerCase().equals("expires")) {
            cookie.setExpires(DateUtils.parseDate(value));
        } else if (key.toLowerCase().equals("discard")) {
            cookie.setDiscard(true);
        } else if (key.toLowerCase().equals("secure")) {
            cookie.setSecure(true);
        } else if (key.toLowerCase().equals("httpOnly")) {
            cookie.setHttpOnly(true);
        } else if (key.toLowerCase().equals("version")) {
            cookie.setVersion(Integer.parseInt(value));
        } else if (key.toLowerCase().equals("comment")) {
            cookie.setComment(value);
        }
    }

    private Cookies() {
    }
}

