/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.ProtectedWrappedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteListenerSettable;

public final class FixedLengthStreamSinkChannel
implements StreamSinkChannel,
ProtectedWrappedChannel<StreamSinkChannel>,
WriteListenerSettable<FixedLengthStreamSinkChannel>,
CloseListenerSettable<FixedLengthStreamSinkChannel> {
    private final StreamSinkChannel delegate;
    private final Object guard;
    private final ChannelListener<? super FixedLengthStreamSinkChannel> finishListener;
    private ChannelListener<? super FixedLengthStreamSinkChannel> writeListener;
    private ChannelListener<? super FixedLengthStreamSinkChannel> closeListener;
    private int state;
    private long count;
    private static final int FLAG_CLOSE_REQUESTED = 1;
    private static final int FLAG_CLOSE_COMPLETE = 2;
    private static final int FLAG_CONFIGURABLE = 4;
    private static final int FLAG_PASS_CLOSE = 8;

    public FixedLengthStreamSinkChannel(StreamSinkChannel delegate, long contentLength, boolean configurable, boolean propagateClose, ChannelListener<? super FixedLengthStreamSinkChannel> finishListener, Object guard) {
        if (contentLength < 0L) {
            throw Messages.msg.parameterOutOfRange("contentLength");
        }
        if (delegate == null) {
            throw Messages.msg.nullParameter("delegate");
        }
        this.guard = guard;
        this.delegate = delegate;
        this.finishListener = finishListener;
        this.state = (configurable ? 4 : 0) | (propagateClose ? 8 : 0);
        this.count = contentLength;
        delegate.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                ChannelListeners.invokeChannelListener(FixedLengthStreamSinkChannel.this, FixedLengthStreamSinkChannel.this.writeListener);
            }
        });
    }

    @Override
    public void setWriteListener(ChannelListener<? super FixedLengthStreamSinkChannel> listener) {
        this.writeListener = listener;
    }

    @Override
    public ChannelListener<? super FixedLengthStreamSinkChannel> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super FixedLengthStreamSinkChannel> listener) {
        this.closeListener = listener;
    }

    @Override
    public ChannelListener<? super FixedLengthStreamSinkChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<FixedLengthStreamSinkChannel> getWriteSetter() {
        return new WriteListenerSettable.Setter<FixedLengthStreamSinkChannel>(this);
    }

    public ChannelListener.Setter<FixedLengthStreamSinkChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<FixedLengthStreamSinkChannel>(this);
    }

    @Override
    public StreamSinkChannel getChannel(Object guard) {
        Object ourGuard = this.guard;
        if (ourGuard == null || guard == ourGuard) {
            return this.delegate;
        }
        return null;
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.allAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (!src.hasRemaining()) {
            return 0;
        }
        int res = 0;
        long remaining = this.count;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        try {
            int lim = src.limit();
            int pos = src.position();
            if ((long)(lim - pos) > remaining) {
                src.limit((int)(remaining - (long)pos));
                try {
                    int n = res = this.delegate.write(src);
                    return n;
                }
                finally {
                    src.limit(lim);
                }
            }
            int n = res = this.delegate.write(src);
            return n;
        }
        finally {
            this.count = remaining - (long)res;
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.allAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        long remaining = this.count;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        long res = 0L;
        long t = 0L;
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = srcs[i + offset];
            int lim = buffer.limit();
            if ((t += (long)(lim - buffer.position())) <= remaining) continue;
            buffer.limit(lim - (int)(t - remaining));
            try {
                long l = res = this.delegate.write(srcs, offset, i + 1);
                return l;
            }
            finally {
                buffer.limit(lim);
            }
        }
        if (t == 0L) {
            long l = 0L;
            return l;
        }
        long l = res = this.delegate.write(srcs, offset, length);
        return l;
        finally {
            this.count = remaining - res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.allAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (count == 0L) {
            return 0L;
        }
        long remaining = this.count;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferFrom(src, position, Math.min(count, remaining));
            return l;
        }
        finally {
            this.count = remaining - res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.allAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (count == 0L) {
            return 0L;
        }
        long remaining = this.count;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferFrom(source, Math.min(count, remaining), throughBuffer);
            return l;
        }
        finally {
            this.count = remaining - res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 2)) {
            return true;
        }
        boolean flushed = false;
        try {
            boolean bl = flushed = this.delegate.flush();
            return bl;
        }
        finally {
            if (flushed && Bits.allAreSet(state, 1)) {
                this.state = state | 2;
                this.callFinish();
                this.callClosed();
                if (this.count != 0L) {
                    throw Messages.msg.fixedUnderflow(this.count);
                }
            }
        }
    }

    @Override
    public void suspendWrites() {
        if (Bits.allAreClear(this.state, 2)) {
            this.delegate.suspendWrites();
        }
    }

    @Override
    public void resumeWrites() {
        if (Bits.allAreClear(this.state, 2)) {
            this.delegate.resumeWrites();
        }
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.allAreClear(this.state, 2) && this.delegate.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        if (Bits.allAreClear(this.state, 2)) {
            this.delegate.wakeupWrites();
        }
    }

    @Override
    public void shutdownWrites() throws IOException {
        int state = this.state;
        if (Bits.allAreSet(state, 1)) {
            return;
        }
        this.state = state | 1;
        if (Bits.allAreSet(state, 8)) {
            this.delegate.shutdownWrites();
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time, timeUnit);
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int state = this.state;
        if (Bits.allAreSet(state, 2)) {
            return;
        }
        this.state = state | 1 | 2;
        try {
            long count = this.count;
            if (count != 0L) {
                if (Bits.allAreSet(state, 8)) {
                    IoUtils.safeClose((Closeable)this.delegate);
                }
                throw Messages.msg.fixedUnderflow(count);
            }
            if (Bits.allAreSet(state, 8)) {
                this.delegate.close();
            }
        }
        finally {
            this.callClosed();
            this.callFinish();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet(this.state, 4) && this.delegate.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return Bits.allAreSet(this.state, 4) ? (T)this.delegate.getOption(option) : null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return Bits.allAreSet(this.state, 4) ? (T)this.delegate.setOption(option, value) : null;
    }

    public long getRemaining() {
        return this.count;
    }

    private void callFinish() {
        ChannelListeners.invokeChannelListener(this, this.finishListener);
    }

    private void callClosed() {
        ChannelListeners.invokeChannelListener(this, this.closeListener);
    }
}

