/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;

public class ClientCertAuthenticationMechanism
implements AuthenticationMechanism {
    private final String name;
    private final boolean forceRenegotiation;

    public ClientCertAuthenticationMechanism() {
        this(true);
    }

    public ClientCertAuthenticationMechanism(boolean forceRenegotiation) {
        this("CLIENT_CERT", forceRenegotiation);
    }

    public ClientCertAuthenticationMechanism(String mechanismName) {
        this(mechanismName, true);
    }

    public ClientCertAuthenticationMechanism(String mechanismName, boolean forceRenegotiation) {
        this.name = mechanismName;
        this.forceRenegotiation = forceRenegotiation;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        SSLSessionInfo sslSession = exchange.getConnection().getSslSessionInfo();
        if (sslSession != null) {
            try {
                Certificate[] clientCerts = sslSession.getPeerCertificates(this.forceRenegotiation);
                if (clientCerts[0] instanceof X509Certificate) {
                    X509CertificateCredential credential = new X509CertificateCredential((X509Certificate)clientCerts[0]);
                    IdentityManager idm = securityContext.getIdentityManager();
                    Account account = idm.verify(credential);
                    if (account != null) {
                        securityContext.authenticationComplete(account, this.name, false);
                        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    }
                }
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }
}

