/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.chat;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.List;
import org.xnio.ChannelListener;

@UndertowExample(value="Chat")
public class ChatServer {
    private static final List<WebSocketChannel> sessions = new ArrayList<WebSocketChannel>();

    public static void main(String[] args) {
        System.out.println("To see chat in action is to open two different browsers and point them at http://localhost:8080");
        Undertow server = Undertow.builder().addListener(8080, "localhost").setHandler(Handlers.path().addPath("/myapp", Handlers.websocket(new WebSocketConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                List list = sessions;
                synchronized (list) {
                    sessions.add(channel);
                    channel.getCloseSetter().set((ChannelListener<AbstractFramedChannel>)new ChannelListener<Channel>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleEvent(Channel channel) {
                            List list = sessions;
                            synchronized (list) {
                                sessions.remove(channel);
                            }
                        }
                    });
                    channel.getReceiveSetter().set(new AbstractReceiveListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
                            String messageData = message.getData();
                            List list = sessions;
                            synchronized (list) {
                                for (WebSocketChannel session : sessions) {
                                    WebSockets.sendText(messageData, session, null);
                                }
                            }
                        }
                    });
                    channel.resumeReceives();
                }
            }
        })).addPath("/", Handlers.resource(new ClassPathResourceManager(ChatServer.class.getClassLoader(), ChatServer.class.getPackage())).addWelcomeFiles("index.html"))).build();
        server.start();
    }
}

