/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.client.ClientConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.Host;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.AttachmentKey;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;

public class LoadBalancingProxyClientWithExclusivity
extends LoadBalancingProxyClient {
    private static final AttachmentKey<ExclusiveConnectionHolder> CONNECTION_HOLDER_KEY = AttachmentKey.create(ExclusiveConnectionHolder.class);
    private final ExclusivityChecker checker;

    public LoadBalancingProxyClientWithExclusivity(ExclusivityChecker checker) {
        this.checker = checker;
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        Host host;
        final ExclusiveConnectionHolder holder = exchange.getConnection().getAttachment(CONNECTION_HOLDER_KEY);
        if (holder != null && holder.connection.getConnection().isOpen()) {
            callback.completed(exchange, holder.connection);
        }
        if ((host = this.selectHost(exchange)) == null) {
            callback.failed(exchange);
        } else if (holder != null || this.checker.isExclusivityRequired(exchange)) {
            host.connect(target, exchange, new ProxyCallback<ProxyConnection>(){

                @Override
                public void failed(HttpServerExchange exchange) {
                    callback.failed(exchange);
                }

                @Override
                public void completed(HttpServerExchange exchange, ProxyConnection result) {
                    if (holder != null) {
                        holder.connection = result;
                    } else {
                        final ExclusiveConnectionHolder newHolder = new ExclusiveConnectionHolder();
                        newHolder.connection = result;
                        ServerConnection connection = exchange.getConnection();
                        connection.putAttachment(CONNECTION_HOLDER_KEY, newHolder);
                        connection.addCloseListener(new ServerConnection.CloseListener(){

                            @Override
                            public void closed(ServerConnection connection) {
                                ClientConnection clientConnection = newHolder.connection.getConnection();
                                if (clientConnection.isOpen()) {
                                    IoUtils.safeClose((Closeable)clientConnection);
                                }
                            }
                        });
                    }
                    callback.completed(exchange, result);
                }
            }, timeout, timeUnit, true);
        } else {
            host.connect(target, exchange, callback, timeout, timeUnit, false);
        }
    }

    private class ExclusiveConnectionHolder {
        private ProxyConnection connection;

        private ExclusiveConnectionHolder() {
        }
    }

    public static interface ExclusivityChecker {
        public boolean isExclusivityRequired(HttpServerExchange var1);
    }
}

