/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.form.FormParserFactory;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.xnio.SslClientAuthMode;

public class ClientCertAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String FORCE_RENEGOTIATION = "force_renegotiation";
    private final String name;
    private final boolean forceRenegotiation;
    public static final Factory FACTORY = new Factory();

    public ClientCertAuthenticationMechanism() {
        this(true);
    }

    public ClientCertAuthenticationMechanism(boolean forceRenegotiation) {
        this("CLIENT_CERT", forceRenegotiation);
    }

    public ClientCertAuthenticationMechanism(String mechanismName) {
        this(mechanismName, true);
    }

    public ClientCertAuthenticationMechanism(String mechanismName, boolean forceRenegotiation) {
        this.name = mechanismName;
        this.forceRenegotiation = forceRenegotiation;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        SSLSessionInfo sslSession = exchange.getConnection().getSslSessionInfo();
        if (sslSession != null) {
            try {
                Certificate[] clientCerts = this.getPeerCertificates(exchange, sslSession);
                if (clientCerts[0] instanceof X509Certificate) {
                    X509CertificateCredential credential = new X509CertificateCredential((X509Certificate)clientCerts[0]);
                    IdentityManager idm = securityContext.getIdentityManager();
                    Account account = idm.verify(credential);
                    if (account != null) {
                        securityContext.authenticationComplete(account, this.name, false);
                        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    }
                }
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private Certificate[] getPeerCertificates(HttpServerExchange exchange, SSLSessionInfo sslSession) throws SSLPeerUnverifiedException {
        try {
            return sslSession.getPeerCertificates();
        }
        catch (RenegotiationRequiredException e) {
            if (this.forceRenegotiation) {
                try {
                    sslSession.renegotiate(exchange, SslClientAuthMode.REQUESTED);
                    return sslSession.getPeerCertificates();
                }
                catch (IOException e1) {
                }
                catch (RenegotiationRequiredException e1) {
                    // empty catch block
                }
            }
            throw new SSLPeerUnverifiedException("");
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    private static final class Factory
    implements AuthenticationMechanismFactory {
        private Factory() {
        }

        @Override
        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            String forceRenegotiation = properties.get(ClientCertAuthenticationMechanism.FORCE_RENEGOTIATION);
            return new ClientCertAuthenticationMechanism(mechanismName, forceRenegotiation == null ? true : "true".equals(forceRenegotiation));
        }
    }
}

