/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.chat;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.websockets.api.AbstractAssembledFrameHandler;
import io.undertow.websockets.api.CloseReason;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@UndertowExample(value="Chat")
public class ChatServer {
    private static final List<WebSocketSession> sessions = new ArrayList<WebSocketSession>();

    public static void main(String[] args) {
        System.out.println("To see chat in action is to open two different browsers and point them at http://localhost:8080");
        Undertow server = Undertow.builder().addListener(8080, "localhost").setHandler(Handlers.path().addPath("/myapp", Handlers.websocket(new WebSocketSessionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSession(WebSocketSession session, WebSocketHttpExchange exchange) {
                List list = sessions;
                synchronized (list) {
                    sessions.add(session);
                }
                session.setFrameHandler(new AbstractAssembledFrameHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onTextFrame(WebSocketSession session, WebSocketFrameHeader header, CharSequence payload) {
                        List list = sessions;
                        synchronized (list) {
                            Iterator it = sessions.iterator();
                            while (it.hasNext()) {
                                WebSocketSession sess = (WebSocketSession)it.next();
                                try {
                                    sess.sendText(payload);
                                }
                                catch (IOException e) {
                                    it.remove();
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCloseFrame(WebSocketSession session, CloseReason reason) {
                        List list = sessions;
                        synchronized (list) {
                            sessions.remove(session);
                        }
                    }
                });
            }
        })).addPath("/", Handlers.resource(new ClassPathResourceManager(ChatServer.class.getClassLoader(), ChatServer.class.getPackage())).addWelcomeFiles("index.html"))).build();
        server.start();
    }
}

