/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.client.HttpClient;
import io.undertow.client.HttpClientConnection;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyClientProvider;
import io.undertow.util.AttachmentKey;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class SimpleProxyClientProvider
implements ProxyClientProvider {
    private final SocketAddress destination;
    private final AttachmentKey<ProxyClient> clientAttachmentKey = AttachmentKey.create(ProxyClient.class);

    public SimpleProxyClientProvider(SocketAddress destination) {
        this.destination = destination;
    }

    @Override
    public void createProxyClient(final HttpServerExchange exchange, final HttpHandler nextHandler, long timeout, TimeUnit timeUnit) {
        ProxyClient existing = exchange.getConnection().getAttachment(this.clientAttachmentKey);
        if (existing != null) {
            exchange.putAttachment(CLIENT, existing);
            exchange.dispatch(SameThreadExecutor.INSTANCE, nextHandler);
            return;
        }
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                HttpClient client = HttpClient.create(exchange.getConnection().getWorker(), OptionMap.EMPTY);
                client.connect(exchange.getIoThread(), SimpleProxyClientProvider.this.destination, OptionMap.EMPTY).addNotifier(new ConnectNotifier(nextHandler), exchange);
            }
        });
    }

    private static final class SimpleProxyClient
    implements ProxyClient {
        private final HttpClientConnection connection;

        private SimpleProxyClient(HttpClientConnection connection) {
            this.connection = connection;
        }

        @Override
        public void getConnection(HttpServerExchange exchange, HttpHandler nextHandler, long timeout, TimeUnit timeUnit) {
            exchange.putAttachment(CONNECTION, this.connection);
            exchange.dispatch(SameThreadExecutor.INSTANCE, nextHandler);
        }
    }

    private final class ConnectNotifier
    extends IoFuture.HandlingNotifier<HttpClientConnection, HttpServerExchange> {
        private final HttpHandler next;

        private ConnectNotifier(HttpHandler next) {
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleCancelled(HttpServerExchange exchange) {
            try {
                if (!exchange.isResponseStarted()) {
                    exchange.setResponseCode(500);
                }
            }
            finally {
                exchange.endExchange();
            }
        }

        @Override
        public void handleFailed(IOException exception, HttpServerExchange exchange) {
            exchange.putAttachment(ProxyClientProvider.THROWABLE, exception);
            exchange.dispatch(SameThreadExecutor.INSTANCE, this.next);
        }

        @Override
        public void handleDone(HttpClientConnection connection, HttpServerExchange exchange) {
            final HttpServerConnection serverConnection = exchange.getConnection();
            SimpleProxyClient simpleProxyClient = new SimpleProxyClient(connection);
            serverConnection.putAttachment(SimpleProxyClientProvider.this.clientAttachmentKey, simpleProxyClient);
            exchange.putAttachment(ProxyClientProvider.CLIENT, simpleProxyClient);
            serverConnection.addCloseListener(new HttpServerConnection.CloseListener(){

                @Override
                public void closed(HttpServerConnection connection) {
                    IoUtils.safeClose((Closeable)serverConnection);
                }
            });
            exchange.dispatch(SameThreadExecutor.INSTANCE, this.next);
        }
    }
}

