/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManager;
import io.undertow.util.ConcurrentDirectDeque;
import io.undertow.util.FastConcurrentDirectDeque;
import io.undertow.util.PortableConcurrentDirectDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;

public class InMemorySessionManager
implements SessionManager {
    private volatile SessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
    private final ConcurrentMap<String, InMemorySession> sessions;
    private final SessionListeners sessionListeners = new SessionListeners();
    private volatile int defaultSessionTimeout = 1800;
    private final int maxSize;
    private final ConcurrentDirectDeque<String> evictionQueue;

    public InMemorySessionManager(int maxSessions) {
        this.sessions = new ConcurrentHashMap<String, InMemorySession>();
        this.maxSize = maxSessions;
        ConcurrentDirectDeque evictionQueue = null;
        if (maxSessions > 0) {
            try {
                evictionQueue = new FastConcurrentDirectDeque();
            }
            catch (Throwable e) {
                evictionQueue = new PortableConcurrentDirectDeque();
            }
        }
        this.evictionQueue = evictionQueue;
    }

    public InMemorySessionManager() {
        this(-1);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (Map.Entry session : this.sessions.entrySet()) {
            ((InMemorySession)session.getValue()).session.destroy();
            this.sessionListeners.sessionDestroyed(((InMemorySession)session.getValue()).session, null, SessionListener.SessionDestroyedReason.UNDEPLOY);
        }
        this.sessions.clear();
    }

    @Override
    public Session createSession(HttpServerExchange serverExchange, SessionConfig config) {
        if (this.evictionQueue != null) {
            while (this.sessions.size() >= this.maxSize && !this.evictionQueue.isEmpty()) {
                String key = (String)this.evictionQueue.poll();
                UndertowLogger.REQUEST_LOGGER.debugf("Removing session %s as max size has been hit", (Object)key);
                InMemorySession toRemove = (InMemorySession)this.sessions.get(key);
                if (toRemove == null) continue;
                toRemove.session.invalidate(null, SessionListener.SessionDestroyedReason.TIMEOUT);
            }
        }
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String sessionID = this.sessionIdGenerator.createSessionId();
        Object evictionToken = this.evictionQueue != null ? this.evictionQueue.offerLastAndReturnToken(sessionID) : null;
        SessionImpl session = new SessionImpl(this, sessionID, config, serverExchange.getIoThread(), serverExchange.getConnection().getWorker(), evictionToken);
        InMemorySession im = new InMemorySession(session, this.defaultSessionTimeout);
        this.sessions.put(sessionID, im);
        config.setSessionId(serverExchange, session.getId());
        im.lastAccessed = System.currentTimeMillis();
        session.bumpTimeout();
        this.sessionListeners.sessionCreated(session, serverExchange);
        return session;
    }

    @Override
    public Session getSession(HttpServerExchange serverExchange, SessionConfig config) {
        String sessionId = config.findSessionId(serverExchange);
        return this.getSession(sessionId);
    }

    @Override
    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        InMemorySession sess = (InMemorySession)this.sessions.get(sessionId);
        if (sess == null) {
            return null;
        }
        return sess.session;
    }

    @Override
    public synchronized void registerSessionListener(SessionListener listener) {
        this.sessionListeners.addSessionListener(listener);
    }

    @Override
    public synchronized void removeSessionListener(SessionListener listener) {
        this.sessionListeners.removeSessionListener(listener);
    }

    @Override
    public void setDefaultSessionTimeout(int timeout) {
        this.defaultSessionTimeout = timeout;
    }

    @Override
    public Set<String> getTransientSessions() {
        return this.getAllSessions();
    }

    @Override
    public Set<String> getActiveSessions() {
        return this.getAllSessions();
    }

    @Override
    public Set<String> getAllSessions() {
        return new HashSet<String>(this.sessions.keySet());
    }

    private static class InMemorySession {
        final SessionImpl session;
        final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        volatile long lastAccessed;
        final long creationTime;
        volatile int maxInactiveInterval;

        InMemorySession(SessionImpl session, int maxInactiveInterval) {
            this.session = session;
            this.creationTime = this.lastAccessed = System.currentTimeMillis();
            this.maxInactiveInterval = maxInactiveInterval;
        }
    }

    private static class SessionImpl
    implements Session {
        private final InMemorySessionManager sessionManager;
        private static volatile AtomicReferenceFieldUpdater<SessionImpl, Object> evictionTokenUpdater = AtomicReferenceFieldUpdater.newUpdater(SessionImpl.class, Object.class, "evictionToken");
        private String sessionId;
        private volatile Object evictionToken;
        private final SessionConfig sessionCookieConfig;
        final XnioExecutor executor;
        final XnioWorker worker;
        XnioExecutor.Key cancelKey;
        Runnable cancelTask = new Runnable(){

            @Override
            public void run() {
                SessionImpl.this.worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        SessionImpl.this.invalidate(null, SessionListener.SessionDestroyedReason.TIMEOUT);
                    }
                });
            }
        };

        private SessionImpl(InMemorySessionManager sessionManager, String sessionId, SessionConfig sessionCookieConfig, XnioExecutor executor, XnioWorker worker, Object evictionToken) {
            this.sessionManager = sessionManager;
            this.sessionId = sessionId;
            this.sessionCookieConfig = sessionCookieConfig;
            this.executor = executor;
            this.worker = worker;
            this.evictionToken = evictionToken;
        }

        synchronized void bumpTimeout() {
            Object token;
            if (this.cancelKey != null && !this.cancelKey.remove()) {
                return;
            }
            if (this.getMaxInactiveInterval() > 0) {
                this.cancelKey = this.executor.executeAfter(this.cancelTask, this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
            if (this.evictionToken != null && evictionTokenUpdater.compareAndSet(this, token = this.evictionToken, null)) {
                this.sessionManager.evictionQueue.removeToken(token);
                this.evictionToken = this.sessionManager.evictionQueue.offerLastAndReturnToken(this.sessionId);
            }
        }

        @Override
        public String getId() {
            return this.sessionId;
        }

        @Override
        public void requestDone(HttpServerExchange serverExchange) {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess != null) {
                sess.lastAccessed = System.currentTimeMillis();
            }
        }

        @Override
        public long getCreationTime() {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.lastAccessed;
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            sess.maxInactiveInterval = interval;
            this.bumpTimeout();
        }

        @Override
        public int getMaxInactiveInterval() {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.maxInactiveInterval;
        }

        @Override
        public Object getAttribute(String name) {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            this.bumpTimeout();
            return sess.attributes.get(name);
        }

        @Override
        public Set<String> getAttributeNames() {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            this.bumpTimeout();
            return sess.attributes.keySet();
        }

        @Override
        public Object setAttribute(String name, Object value) {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            Object existing = sess.attributes.put(name, value);
            if (existing == null) {
                this.sessionManager.sessionListeners.attributeAdded(sess.session, name, value);
            } else {
                this.sessionManager.sessionListeners.attributeUpdated(sess.session, name, value, existing);
            }
            this.bumpTimeout();
            return existing;
        }

        @Override
        public Object removeAttribute(String name) {
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            Object existing = sess.attributes.remove(name);
            this.sessionManager.sessionListeners.attributeRemoved(sess.session, name, existing);
            this.bumpTimeout();
            return existing;
        }

        @Override
        public void invalidate(HttpServerExchange exchange) {
            this.invalidate(exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        }

        synchronized void invalidate(HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            InMemorySession sess;
            if (this.cancelKey != null) {
                this.cancelKey.remove();
            }
            if ((sess = (InMemorySession)this.sessionManager.sessions.get(this.sessionId)) == null) {
                if (reason == SessionListener.SessionDestroyedReason.INVALIDATED) {
                    throw UndertowMessages.MESSAGES.sessionAlreadyInvalidated();
                }
                return;
            }
            this.sessionManager.sessionListeners.sessionDestroyed(sess.session, exchange, reason);
            this.sessionManager.sessions.remove(this.sessionId);
            if (exchange != null) {
                this.sessionCookieConfig.clearSession(exchange, this.getId());
            }
        }

        @Override
        public SessionManager getSessionManager() {
            return this.sessionManager;
        }

        @Override
        public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
            String newId;
            String oldId = this.sessionId;
            InMemorySession sess = (InMemorySession)this.sessionManager.sessions.get(oldId);
            this.sessionId = newId = this.sessionManager.sessionIdGenerator.createSessionId();
            this.sessionManager.sessions.put(newId, sess);
            this.sessionManager.sessions.remove(oldId);
            config.setSessionId(exchange, this.getId());
            this.sessionManager.sessionListeners.sessionIdChanged(sess.session, oldId);
            return newId;
        }

        private synchronized void destroy() {
            if (this.cancelKey != null) {
                this.cancelKey.remove();
            }
            this.cancelTask = null;
        }
    }
}

