/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Pooled;

public class ReferenceCountedPooled<T>
implements Pooled<T> {
    private final Pooled<T> underlying;
    private volatile int referenceCount;
    private volatile boolean discard = false;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedPooled> referenceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedPooled.class, "referenceCount");

    public ReferenceCountedPooled(Pooled<T> underlying, int referenceCount) {
        this.underlying = underlying;
        this.referenceCount = referenceCount;
    }

    @Override
    public void discard() {
        this.discard = true;
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            this.underlying.discard();
        }
    }

    @Override
    public void free() {
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            if (this.discard) {
                this.underlying.discard();
            } else {
                this.underlying.free();
            }
        }
    }

    @Override
    public T getResource() throws IllegalStateException {
        return this.underlying.getResource();
    }

    public Pooled<T> createView(final T newValue) {
        this.increaseReferenceCount();
        return new Pooled<T>(){

            @Override
            public void discard() {
                ReferenceCountedPooled.this.discard();
            }

            @Override
            public void free() {
                ReferenceCountedPooled.this.free();
            }

            @Override
            public T getResource() throws IllegalStateException {
                return newValue;
            }
        };
    }

    public void increaseReferenceCount() {
        int val;
        do {
            if ((val = referenceCountUpdater.get(this)) != 0) continue;
            throw UndertowMessages.MESSAGES.objectWasFreed();
        } while (!referenceCountUpdater.compareAndSet(this, val, val + 1));
    }
}

