/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.ReadListenerSettable;
import org.xnio.channels.SuspendableChannel;
import org.xnio.channels.WrappedChannel;
import org.xnio.channels.WriteListenerSettable;

public abstract class TranslatingSuspendableChannel<C extends SuspendableChannel, W extends SuspendableChannel>
implements SuspendableChannel,
WrappedChannel<W>,
ReadListenerSettable<C>,
WriteListenerSettable<C>,
CloseListenerSettable<C> {
    protected final W channel;
    private ChannelListener<? super C> readListener;
    private ChannelListener<? super C> writeListener;
    private ChannelListener<? super C> closeListener;
    private volatile int state;
    private volatile Thread readWaiter;
    private volatile Thread writeWaiter;
    private static final AtomicIntegerFieldUpdater<TranslatingSuspendableChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(TranslatingSuspendableChannel.class, "state");
    private static final AtomicReferenceFieldUpdater<TranslatingSuspendableChannel, Thread> readWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(TranslatingSuspendableChannel.class, Thread.class, "readWaiter");
    private static final AtomicReferenceFieldUpdater<TranslatingSuspendableChannel, Thread> writeWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(TranslatingSuspendableChannel.class, Thread.class, "writeWaiter");
    private static final int READ_REQUESTED = 1;
    private static final int READ_REQUIRES_WRITE = 2;
    private static final int READ_READY = 4;
    private static final int READ_SHUT_DOWN = 8;
    private static final int READ_REQUIRES_EXT = Bits.intBitMask(11, 15);
    private static final int READ_SINGLE_EXT = 2048;
    private static final int READ_FLAGS = Bits.intBitMask(0, 15);
    private static final int WRITE_REQUESTED = 65536;
    private static final int WRITE_REQUIRES_READ = 131072;
    private static final int WRITE_READY = 262144;
    private static final int WRITE_SHUT_DOWN = 524288;
    private static final int WRITE_COMPLETE = 0x100000;
    private static final int WRITE_REQUIRES_EXT = Bits.intBitMask(27, 31);
    private static final int WRITE_SINGLE_EXT = 0x8000000;
    private static final int WRITE_FLAGS = Bits.intBitMask(16, 31);
    private final ChannelListener<Channel> delegateReadListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            TranslatingSuspendableChannel.this.handleReadable();
        }

        public String toString() {
            return "Read listener for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<Channel> delegateWriteListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            TranslatingSuspendableChannel.this.handleWritable();
        }

        public String toString() {
            return "Write listener for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<Channel> delegateCloseListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            IoUtils.safeClose((Closeable)TranslatingSuspendableChannel.this);
        }

        public String toString() {
            return "Close listener for " + TranslatingSuspendableChannel.this;
        }
    };

    protected TranslatingSuspendableChannel(W channel) {
        if (channel == null) {
            throw Messages.msg.nullParameter("channel");
        }
        this.channel = channel;
        channel.getReadSetter().set(this.delegateReadListener);
        channel.getWriteSetter().set(this.delegateWriteListener);
        channel.getCloseSetter().set(this.delegateCloseListener);
    }

    protected void handleReadable() {
        int oldState = this.clearFlags(131072);
        if (Bits.allAreSet(oldState, 131072)) {
            this.unparkWriteWaiters();
            if (Bits.allAreSet(oldState, 65536)) {
                this.channel.wakeupWrites();
            }
        }
        if (Bits.allAreClear(oldState, 4) && Bits.anyAreSet(oldState, 2 | READ_REQUIRES_EXT)) {
            this.channel.suspendReads();
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 4) || Bits.allAreClear(oldState, 2 | READ_REQUIRES_EXT)) {
                this.channel.resumeReads();
            } else {
                return;
            }
        }
        do {
            if (Bits.anyAreSet(oldState, 8)) {
                this.channel.suspendReads();
                return;
            }
            if (Bits.allAreClear(oldState, 1)) {
                this.channel.suspendReads();
                oldState = this.state;
                if (Bits.allAreSet(oldState, 1)) {
                    this.channel.resumeReads();
                } else {
                    return;
                }
            }
            this.unparkReadWaiters();
            ChannelListener<? super C> listener = this.readListener;
            if (listener == null) {
                oldState = this.clearFlag(131073) & 0xFFFFFFFE;
            } else {
                ChannelListeners.invokeChannelListener(this.thisTyped(), listener);
                oldState = this.clearFlags(131072);
            }
            if (!Bits.allAreSet(oldState, 131072)) continue;
            this.unparkWriteWaiters();
            this.channel.wakeupWrites();
        } while (Bits.allAreSet(oldState, 4));
    }

    protected void handleWritable() {
        int oldState = this.clearFlags(2);
        if (Bits.allAreSet(oldState, 2)) {
            this.unparkReadWaiters();
            if (Bits.allAreSet(oldState, 1)) {
                this.channel.wakeupReads();
            }
        }
        if (Bits.allAreClear(oldState, 262144) && Bits.anyAreSet(oldState, 0x20000 | WRITE_REQUIRES_EXT)) {
            this.channel.suspendWrites();
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 262144) || Bits.allAreClear(oldState, 0x20000 | WRITE_REQUIRES_EXT)) {
                this.channel.resumeWrites();
            } else {
                return;
            }
        }
        do {
            if (Bits.anyAreSet(oldState, 0x100000)) {
                this.channel.suspendWrites();
                return;
            }
            if (Bits.allAreClear(oldState, 65536)) {
                this.channel.suspendWrites();
                oldState = this.state;
                if (Bits.allAreSet(oldState, 65536)) {
                    this.channel.resumeWrites();
                } else {
                    return;
                }
            }
            this.unparkWriteWaiters();
            ChannelListener<? super C> listener = this.writeListener;
            if (listener == null) {
                oldState = this.clearFlags(65538) & 0xFFFEFFFF;
            } else {
                ChannelListeners.invokeChannelListener(this.thisTyped(), listener);
                oldState = this.clearFlags(2);
            }
            if (!Bits.allAreSet(oldState, 2)) continue;
            this.unparkReadWaiters();
            this.channel.wakeupReads();
        } while (Bits.allAreSet(oldState, 262144));
    }

    protected void handleClosed() {
        ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeListener);
    }

    protected void setReadReady() {
        int oldState = this.setFlags(4);
        this.unparkReadWaiters();
        if (Bits.allAreSet(oldState, 4)) {
            return;
        }
        if (Bits.allAreSet(oldState, 1) && Bits.anyAreSet(oldState, READ_REQUIRES_EXT | 2)) {
            this.channel.wakeupReads();
        }
    }

    protected void clearReadReady() {
        int oldState = this.clearFlags(4);
        if (Bits.allAreClear(oldState, 4)) {
            return;
        }
        if (!Bits.allAreClear(oldState, 1) && !Bits.anyAreSet(oldState, READ_REQUIRES_EXT | 2)) {
            this.channel.resumeReads();
        }
    }

    protected void setReadRequiresWrite() {
        int oldState = this.setFlags(2);
        if (Bits.allAreSet(oldState, 2)) {
            return;
        }
        if (Bits.allAreClear(oldState, 4 | READ_REQUIRES_EXT)) {
            this.channel.resumeWrites();
        }
    }

    protected boolean readRequiresWrite() {
        return Bits.allAreSet(this.state, 2);
    }

    protected void clearReadRequiresWrite() {
        int oldState = this.clearFlags(2);
        if (Bits.allAreClear(oldState, 2)) {
            return;
        }
        if (Bits.allAreClear(oldState, READ_REQUIRES_EXT) && Bits.allAreSet(oldState, 1)) {
            if (Bits.allAreSet(oldState, 4)) {
                this.channel.wakeupReads();
            } else {
                this.channel.resumeReads();
            }
        }
    }

    protected boolean tryAddReadRequiresExternal() {
        int oldState = this.addFlag(READ_REQUIRES_EXT, 2048);
        return (oldState & READ_REQUIRES_EXT) != READ_REQUIRES_EXT;
    }

    protected void removeReadRequiresExternal() {
        this.clearFlag(2048);
    }

    protected boolean setReadShutDown() {
        return (this.setFlags(8) & 0x80008) == 524288;
    }

    protected void setWriteReady() {
        int oldState = this.setFlags(262144);
        this.unparkWriteWaiters();
        if (Bits.allAreSet(oldState, 262144)) {
            return;
        }
        if (Bits.allAreSet(oldState, 65536) && Bits.anyAreSet(oldState, WRITE_REQUIRES_EXT | 0x20000)) {
            this.channel.wakeupWrites();
        }
    }

    protected void clearWriteReady() {
        int oldState = this.clearFlags(262144);
        if (Bits.allAreClear(oldState, 262144)) {
            return;
        }
        if (!Bits.allAreClear(oldState, 65536) && !Bits.anyAreSet(oldState, WRITE_REQUIRES_EXT | 0x20000)) {
            this.channel.resumeWrites();
        }
    }

    protected void setWriteRequiresRead() {
        int oldState = this.setFlags(131072);
        if (Bits.allAreSet(oldState, 131072)) {
            return;
        }
        if (Bits.allAreClear(oldState, 0x40000 | WRITE_REQUIRES_EXT)) {
            this.channel.resumeReads();
        }
    }

    protected boolean writeRequiresRead() {
        return Bits.allAreSet(this.state, 131072);
    }

    protected void clearWriteRequiresRead() {
        int oldState = this.clearFlags(131072);
        if (Bits.allAreClear(oldState, 131072)) {
            return;
        }
        if (Bits.allAreClear(oldState, WRITE_REQUIRES_EXT) && Bits.allAreSet(oldState, 65536)) {
            if (Bits.allAreSet(oldState, 262144)) {
                this.channel.wakeupWrites();
            } else {
                this.channel.resumeWrites();
            }
        }
    }

    protected boolean tryAddWriteRequiresExternal() {
        int oldState = this.addFlag(WRITE_REQUIRES_EXT, 0x8000000);
        return (oldState & WRITE_REQUIRES_EXT) != WRITE_REQUIRES_EXT;
    }

    protected void removeWriteRequiresExternal() {
        this.clearFlag(0x8000000);
    }

    protected boolean setWriteShutDown() {
        return (this.setFlags(524288) & 0x80008) == 8;
    }

    protected boolean setClosed() {
        return (this.setFlags(524296) & 0x80008) != 524296;
    }

    protected final C thisTyped() {
        return (C)this;
    }

    @Override
    public void setReadListener(ChannelListener<? super C> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super C> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setWriteListener(ChannelListener<? super C> writeListener) {
        this.writeListener = writeListener;
    }

    @Override
    public ChannelListener<? super C> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super C> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super C> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<C> getCloseSetter() {
        return new CloseListenerSettable.Setter(this);
    }

    public ChannelListener.Setter<C> getReadSetter() {
        return new ReadListenerSettable.Setter(this);
    }

    public ChannelListener.Setter<C> getWriteSetter() {
        return new WriteListenerSettable.Setter(this);
    }

    @Override
    public void suspendReads() {
        this.clearFlags(1);
    }

    @Override
    public void resumeReads() {
        int oldState = this.setFlags(1);
        if (Bits.anyAreSet(oldState, 9)) {
            return;
        }
        if (Bits.allAreSet(oldState, 4)) {
            this.channel.wakeupReads();
            return;
        }
        if (Bits.allAreClear(oldState, READ_REQUIRES_EXT)) {
            if (Bits.allAreSet(oldState, 2)) {
                this.channel.resumeWrites();
            } else {
                this.channel.resumeReads();
            }
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreSet(this.state, 1);
    }

    @Override
    public void wakeupReads() {
        if (Bits.anyAreSet(this.state, 8)) {
            return;
        }
        this.setFlags(1);
        this.channel.wakeupReads();
    }

    @Override
    public void suspendWrites() {
        this.clearFlags(65536);
    }

    @Override
    public void resumeWrites() {
        int oldState = this.setFlags(65536);
        if (Bits.anyAreSet(oldState, 0x110000)) {
            return;
        }
        if (Bits.allAreSet(oldState, 262144)) {
            this.channel.wakeupWrites();
            return;
        }
        if (Bits.allAreClear(oldState, WRITE_REQUIRES_EXT)) {
            if (Bits.allAreSet(oldState, 131072)) {
                this.channel.resumeReads();
            } else {
                this.channel.resumeWrites();
            }
        }
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.allAreSet(this.state, 65536);
    }

    @Override
    public void wakeupWrites() {
        if (Bits.anyAreSet(this.state, 524288)) {
            return;
        }
        this.setFlags(65536);
        this.channel.wakeupWrites();
        this.unparkWriteWaiters();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.channel.setOption(option, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean flush() throws IOException {
        int oldState = stateUpdater.get(this);
        if (Bits.allAreSet(oldState, 0x100000)) {
            return this.channel.flush();
        }
        boolean shutDown = Bits.allAreSet(oldState, 524288);
        if (!this.flushAction(shutDown)) {
            return false;
        }
        if (!shutDown) {
            return true;
        }
        int newState = oldState | 0x100000;
        while (!stateUpdater.compareAndSet(this, oldState, newState)) {
            oldState = stateUpdater.get(this);
            if (Bits.allAreSet(oldState, 0x100000)) {
                return this.channel.flush();
            }
            newState = oldState | 0x100000;
        }
        boolean readShutDown = Bits.allAreSet(oldState, 8);
        try {
            this.shutdownWritesComplete(readShutDown);
        }
        finally {
            if (readShutDown) {
                ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeListener);
            }
        }
        return this.channel.flush();
    }

    protected boolean flushAction(boolean shutDown) throws IOException {
        return this.channel.flush();
    }

    protected void shutdownWritesComplete(boolean readShutDown) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownReads() throws IOException {
        int old = this.setFlags(8);
        if (Bits.allAreClear(old, 8)) {
            boolean writeComplete = Bits.allAreSet(old, 0x100000);
            try {
                this.shutdownReadsAction(writeComplete);
            }
            finally {
                if (writeComplete) {
                    ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeListener);
                }
            }
        }
    }

    protected void shutdownReadsAction(boolean writeComplete) throws IOException {
        this.channel.shutdownReads();
    }

    protected boolean isReadShutDown() {
        return Bits.allAreSet(this.state, 8);
    }

    @Override
    public void shutdownWrites() throws IOException {
        int old = this.setFlags(524288);
        if (Bits.allAreClear(old, 524288)) {
            this.shutdownWritesAction();
        }
    }

    protected void shutdownWritesAction() throws IOException {
        this.channel.shutdownWrites();
    }

    protected boolean isWriteShutDown() {
        return Bits.allAreSet(this.state, 524288);
    }

    protected boolean isWriteComplete() {
        return Bits.allAreSet(this.state, 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable() throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 12)) {
            return;
        }
        Thread thread = Thread.currentThread();
        Thread next = readWaiterUpdater.getAndSet(this, thread);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 12)) {
                return;
            }
            if (Bits.allAreSet(oldState, 2)) {
                this.channel.resumeWrites();
            } else {
                this.channel.resumeReads();
            }
            LockSupport.park(this);
            if (thread.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 12)) {
            return;
        }
        Thread thread = Thread.currentThread();
        Thread next = readWaiterUpdater.getAndSet(this, thread);
        long duration = timeUnit.toNanos(time);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 12)) {
                return;
            }
            if (Bits.allAreSet(oldState, 2)) {
                this.channel.resumeWrites();
            } else {
                this.channel.resumeReads();
            }
            LockSupport.parkNanos(this, duration);
            if (thread.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.channel.getReadThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 786432)) {
            return;
        }
        Thread thread = Thread.currentThread();
        Thread next = writeWaiterUpdater.getAndSet(this, thread);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 786432)) {
                return;
            }
            if (Bits.allAreSet(oldState, 131072)) {
                this.channel.resumeReads();
            } else {
                this.channel.resumeWrites();
            }
            LockSupport.park(this);
            if (thread.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 786432)) {
            return;
        }
        Thread thread = Thread.currentThread();
        Thread next = writeWaiterUpdater.getAndSet(this, thread);
        long duration = timeUnit.toNanos(time);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 786432)) {
                return;
            }
            if (Bits.allAreSet(oldState, 131072)) {
                this.channel.resumeReads();
            } else {
                this.channel.resumeWrites();
            }
            LockSupport.parkNanos(this, duration);
            if (thread.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    private void unparkReadWaiters() {
        Thread waiter = readWaiterUpdater.getAndSet(this, null);
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    private void unparkWriteWaiters() {
        Thread waiter = writeWaiterUpdater.getAndSet(this, null);
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.channel.getWriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int old = this.setFlags(0x180008);
        boolean readShutDown = Bits.allAreSet(old, 8);
        boolean writeShutDown = Bits.allAreSet(old, 0x100000);
        if (!readShutDown || !writeShutDown) {
            try {
                this.closeAction(readShutDown, writeShutDown);
            }
            finally {
                ChannelListeners.invokeChannelListener(this.thisTyped(), this.closeListener);
            }
        }
    }

    protected void closeAction(boolean readShutDown, boolean writeShutDown) throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return !Bits.allAreSet(this.state, 0x100008);
    }

    @Override
    public W getChannel() {
        return this.channel;
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    public String toString() {
        return this.getClass().getName() + " around " + this.channel;
    }

    private int setFlags(int flags) {
        int oldState;
        do {
            if (((oldState = this.state) & flags) != flags) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | flags));
        return oldState;
    }

    private int clearFlags(int flags) {
        int oldState;
        do {
            if (((oldState = this.state) & flags) != 0) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState & ~flags));
        return oldState;
    }

    private int addFlag(int mask, int count) {
        int oldState;
        do {
            if (((oldState = this.state) & mask) != mask) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState + count));
        return oldState;
    }

    private int clearFlag(int count) {
        return stateUpdater.getAndAdd(this, -count);
    }
}

