/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.server.SSLSessionInfo;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class AjpSSLSessionInfo
implements SSLSessionInfo {
    private final byte[] id;
    private final String cypherSuite;
    private final Certificate peerCertificate;
    private final X509Certificate certificate;

    public AjpSSLSessionInfo(byte[] id, String cypherSuite, byte[] certificate) throws java.security.cert.CertificateException, CertificateException {
        this.id = id;
        this.cypherSuite = cypherSuite;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream stream = new ByteArrayInputStream(certificate);
        this.peerCertificate = cf.generateCertificate(stream);
        this.certificate = X509Certificate.getInstance(certificate);
    }

    @Override
    public byte[] getId() {
        return this.id;
    }

    @Override
    public String getCipherSuite() {
        return this.cypherSuite;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return new Certificate[]{this.peerCertificate};
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return new X509Certificate[]{this.certificate};
    }
}

