/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ExchangeCookieUtils {
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";

    private ExchangeCookieUtils() {
    }

    public static Map<String, Cookie> parseRequestCookies(HttpServerExchange exchange) {
        HeaderValues cookies = exchange.getRequestHeaders().get(Headers.COOKIE);
        if (cookies == null) {
            return new TreeMap<String, Cookie>();
        }
        TreeMap<String, Cookie> parsedCookies = new TreeMap<String, Cookie>();
        int maxCookies = exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_COOKIES, 200);
        for (String cookie : cookies) {
            ExchangeCookieUtils.parseCookie(cookie, parsedCookies, maxCookies);
        }
        return parsedCookies;
    }

    private static void parseCookie(String cookie, Map<String, Cookie> parsedCookies, int maxCookies) {
        int state = 0;
        String name = null;
        int start = 0;
        int cookieCount = parsedCookies.size();
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block6: for (int i = 0; i < cookie.length(); ++i) {
            char c = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == ';') {
                        start = i + 1;
                        continue block6;
                    }
                    state = 1;
                }
                case 1: {
                    if (c == '=') {
                        name = cookie.substring(start, i);
                        start = i + 1;
                        state = 2;
                        continue block6;
                    }
                    if (c != ';') continue block6;
                    String value = cookie.substring(start, i);
                    if (++cookieCount == maxCookies) {
                        throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
                    }
                    if (name.startsWith("$")) {
                        additional.put(name, value);
                    } else {
                        cookies.put(name, value);
                    }
                    state = 0;
                    start = i + 1;
                    continue block6;
                }
                case 2: {
                    String value;
                    if (c == ';') {
                        value = cookie.substring(start, i);
                        if (++cookieCount == maxCookies) {
                            throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
                        }
                        if (name.startsWith("$")) {
                            additional.put(name, value);
                        } else {
                            cookies.put(name, value);
                        }
                        state = 0;
                        start = i + 1;
                        continue block6;
                    }
                    if (c != '\"') continue block6;
                    state = 3;
                    start = i + 1;
                    continue block6;
                }
                case 3: {
                    if (c != '\"') continue block6;
                    String value = cookie.substring(start, i);
                    if (++cookieCount == maxCookies) {
                        throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
                    }
                    if (name.startsWith("$")) {
                        additional.put(name, value);
                    } else {
                        cookies.put(name, value);
                    }
                    state = 0;
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            String value = cookie.substring(start);
            if (++cookieCount == maxCookies) {
                throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
            }
            if (name.startsWith("$")) {
                additional.put(name, value);
            } else {
                cookies.put(name, value);
            }
        }
        for (Map.Entry entry : cookies.entrySet()) {
            CookieImpl c = new CookieImpl((String)entry.getKey(), (String)entry.getValue());
            if (additional.containsKey(DOMAIN)) {
                c.setDomain((String)additional.get(DOMAIN));
            }
            if (additional.containsKey(VERSION)) {
                c.setVersion(Integer.parseInt((String)additional.get(VERSION)));
            }
            if (additional.containsKey(PATH)) {
                c.setPath((String)additional.get(PATH));
            }
            parsedCookies.put(c.getName(), c);
        }
    }

    private static String getCookieString(Cookie cookie) {
        switch (cookie.getVersion()) {
            case 0: {
                return ExchangeCookieUtils.addVersion0ResponseCookieToExchange(cookie);
            }
        }
        return ExchangeCookieUtils.addVersion1ResponseCookieToExchange(cookie);
    }

    private static String addVersion0ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        header.append(cookie.getValue());
        if (cookie.getPath() != null) {
            header.append("; path=");
            header.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.isSecure()) {
            header.append("; secure");
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toOldCookieDateString(cookie.getExpires()));
        } else if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() == 0) {
                Date expires = new Date();
                expires.setTime(0L);
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            } else if (cookie.getMaxAge() > 0) {
                Date expires = new Date();
                expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue());
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            }
        }
        return header.toString();
    }

    private static String addVersion1ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        header.append(cookie.getValue());
        header.append("; Version=1");
        if (cookie.getPath() != null) {
            header.append("; Path=");
            header.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getMaxAge() != null && cookie.getMaxAge() >= 0) {
            header.append("; Max-Age=");
            header.append(cookie.getMaxAge());
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
        }
        return header.toString();
    }

    public static void flattenCookies(HttpServerExchange exchange) {
        Map<String, Cookie> cookies = exchange.getResponseCookiesInternal();
        if (cookies != null) {
            for (Map.Entry<String, Cookie> entry : cookies.entrySet()) {
                StringBuilder builder = new StringBuilder();
                builder.append(ExchangeCookieUtils.getCookieString(entry.getValue()));
                exchange.getResponseHeaders().add(Headers.SET_COOKIE, builder.toString());
            }
        }
    }
}

