/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.websockets;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.StreamConnection;

public class WebSocketServlet
extends HttpServlet {
    public static final String SESSION_HANDLER = "io.undertow.handler";
    private final List<Handshake> handshakes;
    private WebSocketConnectionCallback callback;

    public WebSocketServlet() {
        this.handshakes = this.handshakes();
    }

    public WebSocketServlet(WebSocketConnectionCallback callback) {
        this.callback = callback;
        this.handshakes = this.handshakes();
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String sessionHandler = config.getInitParameter(SESSION_HANDLER);
            if (sessionHandler != null) {
                Class<?> clazz = Class.forName(sessionHandler, true, Thread.currentThread().getContextClassLoader());
                Object handler = clazz.newInstance();
                this.callback = (WebSocketConnectionCallback)handler;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(e);
        }
        catch (InstantiationException e) {
            throw new ServletException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException(e);
        }
        if (this.callback == null) {
            throw UndertowServletMessages.MESSAGES.noWebSocketHandler();
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp);
        Handshake handshaker = null;
        for (Handshake method : this.handshakes) {
            if (!method.matches(facade)) continue;
            handshaker = method;
            break;
        }
        if (handshaker == null) {
            UndertowLogger.REQUEST_LOGGER.debug("Could not find hand shaker for web socket request");
            resp.sendError(400);
            return;
        }
        final Handshake selected = handshaker;
        facade.upgradeChannel(new HttpUpgradeListener(){

            @Override
            public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                WebSocketChannel channel = selected.createChannel(facade, streamConnection, facade.getBufferPool());
                WebSocketServlet.this.callback.onConnect(facade, channel);
            }
        });
        handshaker.handshake(facade);
    }

    protected List<Handshake> handshakes() {
        ArrayList<Handshake> handshakes = new ArrayList<Handshake>();
        handshakes.add(new Hybi13Handshake());
        handshakes.add(new Hybi08Handshake());
        handshakes.add(new Hybi07Handshake());
        return handshakes;
    }
}

