/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityContextFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SecurityContextFactoryImpl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class SecurityInitialHandler
implements HttpHandler {
    private final AuthenticationMode authenticationMode;
    private final IdentityManager identityManager;
    private final HttpHandler next;
    private final String programaticMechName;
    private final SecurityContextFactory contextFactory;

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, String programaticMechName, SecurityContextFactory contextFactory, HttpHandler next) {
        this.authenticationMode = authenticationMode;
        this.identityManager = identityManager;
        this.programaticMechName = programaticMechName;
        this.contextFactory = contextFactory;
        this.next = next;
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, String programaticMechName, HttpHandler next) {
        this(authenticationMode, identityManager, programaticMechName, SecurityContextFactoryImpl.INSTANCE, next);
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, HttpHandler next) {
        this(authenticationMode, identityManager, null, SecurityContextFactoryImpl.INSTANCE, next);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext newContext = this.contextFactory.createSecurityContext(exchange, this.authenticationMode, this.identityManager, this.programaticMechName);
        exchange.setSecurityContext(newContext);
        this.next.handleRequest(exchange);
    }
}

