/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ConnectionPoolManager;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.CopyOnWriteMap;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;

class ProxyConnectionPool
implements Closeable {
    private final URI uri;
    private final UndertowClient client;
    private final ConnectionPoolManager connectionPoolManager;
    private volatile boolean problem;
    private volatile boolean closed;
    private final ConcurrentMap<XnioIoThread, HostThreadData> hostThreadData = new CopyOnWriteMap<XnioIoThread, HostThreadData>();

    public ProxyConnectionPool(ConnectionPoolManager connectionPoolManager, URI uri, UndertowClient client) {
        this.connectionPoolManager = connectionPoolManager;
        this.uri = uri;
        this.client = client;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void returnConnection(ClientConnection connection) {
        HostThreadData hostData = this.getData();
        if (this.closed) {
            IoUtils.safeClose((Closeable)connection);
            ClientConnection con = hostData.availableConnections.poll();
            while (con != null) {
                IoUtils.safeClose((Closeable)con);
                con = hostData.availableConnections.poll();
            }
            this.redistributeQueued(hostData);
            return;
        }
        if (connection.isOpen() && !connection.isUpgraded()) {
            CallbackHolder callback = hostData.awaitingConnections.poll();
            while (callback != null && callback.isCancelled()) {
                callback = hostData.awaitingConnections.poll();
            }
            if (callback != null) {
                if (callback.getTimeoutKey() != null) {
                    callback.getTimeoutKey().remove();
                }
                this.connectionReady(connection, callback.getCallback(), callback.getExchange(), false);
            } else {
                hostData.availableConnections.add(connection);
            }
        } else if (connection.isOpen() && connection.isUpgraded()) {
            connection.getCloseSetter().set(null);
            this.handleClosedConnection(hostData, connection);
        }
    }

    private void handleClosedConnection(HostThreadData hostData, ClientConnection connection) {
        int connections = --hostData.connections;
        hostData.availableConnections.remove(connection);
        if (this.connectionPoolManager.canCreateConnection(connections, this)) {
            CallbackHolder task = hostData.awaitingConnections.poll();
            while (task != null && task.isCancelled()) {
                task = hostData.awaitingConnections.poll();
            }
            if (task != null) {
                this.openConnection(task.exchange, task.callback, hostData, false);
            }
        }
    }

    private void openConnection(final HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, final HostThreadData data, final boolean exclusive) {
        if (!exclusive) {
            ++data.connections;
        }
        this.client.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection result) {
                ProxyConnectionPool.this.problem = false;
                if (!exclusive) {
                    result.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<ClientConnection>(){

                        @Override
                        public void handleEvent(ClientConnection channel) {
                            ProxyConnectionPool.this.handleClosedConnection(data, channel);
                        }
                    });
                }
                ProxyConnectionPool.this.connectionReady(result, callback, exchange, exclusive);
            }

            @Override
            public void failed(IOException e) {
                if (!exclusive) {
                    --data.connections;
                }
                ProxyConnectionPool.this.problem = true;
                ProxyConnectionPool.this.redistributeQueued(ProxyConnectionPool.this.getData());
                ProxyConnectionPool.this.scheduleFailedHostRetry(exchange);
                callback.failed(exchange);
            }
        }, this.getUri(), exchange.getIoThread(), exchange.getConnection().getBufferPool(), OptionMap.EMPTY);
    }

    private void redistributeQueued(HostThreadData hostData) {
        CallbackHolder callback = hostData.awaitingConnections.poll();
        while (callback != null) {
            if (callback.getTimeoutKey() != null) {
                callback.getTimeoutKey().remove();
            }
            if (!callback.isCancelled()) {
                long time = System.currentTimeMillis();
                if (callback.getExpireTime() > 0L && callback.getExpireTime() < time) {
                    callback.getCallback().failed(callback.getExchange());
                } else {
                    this.connectionPoolManager.queuedConnectionFailed(callback.getProxyTarget(), callback.getExchange(), callback.getCallback(), callback.getExpireTime() > 0L ? time - callback.getExpireTime() : -1L);
                    callback.getCallback().failed(callback.getExchange());
                }
            }
            callback = hostData.awaitingConnections.poll();
        }
    }

    private void connectionReady(final ClientConnection result, ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange, final boolean exclusive) {
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                if (!exclusive) {
                    ProxyConnectionPool.this.returnConnection(result);
                }
                nextListener.proceed();
            }
        });
        callback.completed(exchange, new ProxyConnection(result, this.uri.getPath() == null ? "/" : this.uri.getPath()));
    }

    public AvailabilityType available() {
        if (this.closed) {
            return AvailabilityType.CLOSED;
        }
        if (this.problem) {
            return AvailabilityType.PROBLEM;
        }
        HostThreadData data = this.getData();
        if (this.connectionPoolManager.canCreateConnection(data.connections, this)) {
            return AvailabilityType.AVAILABLE;
        }
        if (!data.availableConnections.isEmpty()) {
            return AvailabilityType.AVAILABLE;
        }
        return AvailabilityType.FULL;
    }

    private void scheduleFailedHostRetry(final HttpServerExchange exchange) {
        exchange.getIoThread().executeAfter(new Runnable(){

            @Override
            public void run() {
                if (ProxyConnectionPool.this.closed) {
                    return;
                }
                ProxyConnectionPool.this.client.connect(new ClientCallback<ClientConnection>(){

                    @Override
                    public void completed(ClientConnection result) {
                        ProxyConnectionPool.this.problem = false;
                        ProxyConnectionPool.this.returnConnection(result);
                    }

                    @Override
                    public void failed(IOException e) {
                        ProxyConnectionPool.this.scheduleFailedHostRetry(exchange);
                    }
                }, ProxyConnectionPool.this.getUri(), exchange.getIoThread(), exchange.getConnection().getBufferPool(), OptionMap.EMPTY);
            }
        }, this.connectionPoolManager.getProblemServerRetry(), TimeUnit.SECONDS);
    }

    private HostThreadData getData() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof XnioIoThread)) {
            throw UndertowMessages.MESSAGES.canOnlyBeCalledByIoThread();
        }
        XnioIoThread ioThread = (XnioIoThread)thread;
        HostThreadData data = (HostThreadData)this.hostThreadData.get(ioThread);
        if (data != null) {
            return data;
        }
        data = new HostThreadData();
        HostThreadData existing = this.hostThreadData.putIfAbsent(ioThread, data);
        if (existing != null) {
            return existing;
        }
        return data;
    }

    public void connect(ProxyClient.ProxyTarget proxyTarget, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit, boolean exclusive) {
        HostThreadData data = this.getData();
        ClientConnection conn = data.availableConnections.poll();
        while (conn != null && !conn.isOpen()) {
            conn = data.availableConnections.poll();
        }
        if (conn != null) {
            if (exclusive) {
                --data.connections;
            }
            this.connectionReady(conn, callback, exchange, exclusive);
        } else if (exclusive || this.connectionPoolManager.canCreateConnection(data.connections, this)) {
            this.openConnection(exchange, callback, data, exclusive);
        } else {
            CallbackHolder holder;
            if (timeout > 0L) {
                long time = System.currentTimeMillis();
                holder = new CallbackHolder(proxyTarget, callback, exchange, time + timeUnit.toMillis(timeout));
                holder.setTimeoutKey(exchange.getIoThread().executeAfter(holder, timeout, timeUnit));
            } else {
                holder = new CallbackHolder(proxyTarget, callback, exchange, -1L);
            }
            data.awaitingConnections.add(holder);
        }
    }

    static enum AvailabilityType {
        AVAILABLE,
        DRAIN,
        FULL,
        PROBLEM,
        CLOSED;

    }

    private static final class CallbackHolder
    implements Runnable {
        final ProxyClient.ProxyTarget proxyTarget;
        final ProxyCallback<ProxyConnection> callback;
        final HttpServerExchange exchange;
        final long expireTime;
        XnioExecutor.Key timeoutKey;
        boolean cancelled = false;

        private CallbackHolder(ProxyClient.ProxyTarget proxyTarget, ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange, long expireTime) {
            this.proxyTarget = proxyTarget;
            this.callback = callback;
            this.exchange = exchange;
            this.expireTime = expireTime;
        }

        private ProxyCallback<ProxyConnection> getCallback() {
            return this.callback;
        }

        private HttpServerExchange getExchange() {
            return this.exchange;
        }

        private long getExpireTime() {
            return this.expireTime;
        }

        private XnioExecutor.Key getTimeoutKey() {
            return this.timeoutKey;
        }

        private boolean isCancelled() {
            return this.cancelled;
        }

        private void setTimeoutKey(XnioExecutor.Key timeoutKey) {
            this.timeoutKey = timeoutKey;
        }

        @Override
        public void run() {
            this.cancelled = true;
            this.callback.failed(this.exchange);
        }

        public ProxyClient.ProxyTarget getProxyTarget() {
            return this.proxyTarget;
        }
    }

    private static final class HostThreadData {
        int connections = 0;
        final Deque<ClientConnection> availableConnections = new ArrayDeque<ClientConnection>();
        final Deque<CallbackHolder> awaitingConnections = new ArrayDeque<CallbackHolder>();

        private HostThreadData() {
        }
    }
}

