/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.spec.WebConnectionImpl;
import javax.servlet.http.HttpUpgradeHandler;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;

public class ServletUpgradeListener<T extends HttpUpgradeHandler>
implements HttpUpgradeListener {
    private final InstanceHandle<T> instance;
    private final ThreadSetupAction threadSetupAction;
    private final HttpServerExchange exchange;

    public ServletUpgradeListener(InstanceHandle<T> instance, ThreadSetupAction threadSetupAction, HttpServerExchange exchange) {
        this.instance = instance;
        this.threadSetupAction = threadSetupAction;
        this.exchange = exchange;
    }

    @Override
    public void handleUpgrade(final StreamConnection channel, HttpServerExchange exchange) {
        channel.getCloseSetter().set((ChannelListener<? extends StreamConnection>)new ChannelListener<StreamConnection>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(StreamConnection channel) {
                ThreadSetupAction.Handle handle = ServletUpgradeListener.this.threadSetupAction.setup(ServletUpgradeListener.this.exchange);
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).destroy();
                }
                finally {
                    try {
                        handle.tearDown();
                    }
                    finally {
                        ServletUpgradeListener.this.instance.release();
                    }
                }
            }
        });
        this.exchange.getConnection().getWorker().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadSetupAction.Handle handle = ServletUpgradeListener.this.threadSetupAction.setup(ServletUpgradeListener.this.exchange);
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).init(new WebConnectionImpl(channel, ServletUpgradeListener.this.exchange.getConnection().getBufferPool()));
                }
                finally {
                    handle.tearDown();
                }
            }
        });
    }
}

