/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class ReadTimeoutStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private XnioExecutor.Key handle;
    private final StreamConnection connection;
    private static final int FUZZ_FACTOR = 50;
    private final Runnable timeoutCommand = new Runnable(){

        @Override
        public void run() {
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            IoUtils.safeClose((Closeable)ReadTimeoutStreamSourceConduit.this.connection);
            if (ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel().isReadResumed()) {
                ChannelListeners.invokeChannelListener(ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel(), ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel().getReadListener());
            }
            if (ReadTimeoutStreamSourceConduit.this.connection.getSinkChannel().isWriteResumed()) {
                ChannelListeners.invokeChannelListener(ReadTimeoutStreamSourceConduit.this.connection.getSinkChannel(), ReadTimeoutStreamSourceConduit.this.connection.getSinkChannel().getWriteListener());
            }
        }
    };

    public ReadTimeoutStreamSourceConduit(StreamSourceConduit delegate, StreamConnection connection) {
        super(delegate);
        this.connection = connection;
    }

    private void handleReadTimeout(long ret) throws IOException {
        Integer readTimeout = this.connection.getOption(Options.READ_TIMEOUT);
        if (readTimeout != null && readTimeout > 0) {
            if (ret == 0L && this.handle == null) {
                this.handle = super.getReadThread().executeAfter(this.timeoutCommand, readTimeout + 50, TimeUnit.MILLISECONDS);
            } else if (ret > 0L && this.handle != null) {
                this.handle.remove();
            }
        }
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long ret = super.transferTo(position, count, target);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long ret = super.transferTo(count, throughBuffer, target);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = super.read(dsts, offset, length);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int ret = super.read(dst);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public void awaitReadable() throws IOException {
        Integer timeout = this.connection.getOption(Options.READ_TIMEOUT);
        if (timeout != null && timeout > 0) {
            super.awaitReadable(timeout + 50, TimeUnit.MILLISECONDS);
        } else {
            super.awaitReadable();
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        Integer timeout = this.connection.getOption(Options.READ_TIMEOUT);
        if (timeout != null && timeout > 0) {
            long millis = timeUnit.toMillis(time);
            super.awaitReadable(Math.min(millis, (long)(timeout + 50)), TimeUnit.MILLISECONDS);
        } else {
            super.awaitReadable(time, timeUnit);
        }
    }
}

