/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.client.UndertowClientMessages;
import io.undertow.client.ajp.AjpClientConnection;
import io.undertow.client.ajp.AjpClientRequestConduit;
import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

class AjpClientResponseConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final AjpClientConnection connection;
    private final AjpClientRequestConduit ajpClientRequestConduit;
    private static final int HEADER_LENGTH = 7;
    private static final int AJP13_SEND_BODY_CHUNK = 3;
    private static final int AJP13_END_RESPONSE = 5;
    private static final int AJP13_GET_BODY_CHUNK = 6;
    private final ByteBuffer headerBuffer = ByteBuffer.allocateDirect(7);
    private final ConduitListener<? super AjpClientResponseConduit> finishListener;
    private long state;
    private static final long STATE_FINISHED = Long.MIN_VALUE;
    private static final long STATE_MASK = Bits.longBitMask(0, 62);

    public AjpClientResponseConduit(StreamSourceConduit delegate, AjpClientConnection connection, AjpClientRequestConduit ajpClientRequestConduit, ConduitListener<? super AjpClientResponseConduit> finishListener) {
        super(delegate);
        this.connection = connection;
        this.ajpClientRequestConduit = ajpClientRequestConduit;
        this.finishListener = finishListener;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < length; ++i) {
            while (dsts[i].hasRemaining()) {
                int r = this.read(dsts[i]);
                if (r <= 0 && total > 0L) {
                    return total;
                }
                if (r <= 0) {
                    return r;
                }
                total += (long)r;
            }
        }
        return total;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        long state = this.state;
        if (Bits.anyAreSet(state, Long.MIN_VALUE)) {
            return -1;
        }
        return this.doRead(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead(ByteBuffer dst) throws IOException {
        long chunkRemaining;
        ByteBuffer headerBuffer = this.headerBuffer;
        boolean val = false;
        if (!this.headerRead()) {
            val = true;
            int read = ((StreamSourceConduit)this.next).read(headerBuffer);
            if (read == -1) {
                this.handleFinish();
                return -1;
            }
            if (!this.headerRead()) {
                return 0;
            }
            headerBuffer.flip();
            byte b1 = headerBuffer.get();
            byte b2 = headerBuffer.get();
            if (b1 != 65 || b2 != 66) {
                throw UndertowClientMessages.MESSAGES.wrongMagicNumber("AB", "" + (char)b1 + (char)b2);
            }
            headerBuffer.get();
            headerBuffer.get();
            byte packetType = headerBuffer.get();
            switch (packetType) {
                case 6: {
                    b1 = headerBuffer.get();
                    b2 = headerBuffer.get();
                    int requestedSize = (b1 & 0xFF) << 8 | b2 & 0xFF;
                    this.ajpClientRequestConduit.setBodyChunkRequested(requestedSize);
                    headerBuffer.clear();
                    return 0;
                }
                case 5: {
                    this.ajpClientRequestConduit.setRequestDone();
                    byte persistent = headerBuffer.get();
                    if (persistent == 0) {
                        this.connection.requestClose();
                    }
                    this.handleFinish();
                    return -1;
                }
                case 3: {
                    b1 = headerBuffer.get();
                    b2 = headerBuffer.get();
                    chunkRemaining = ((b1 & 0xFF) << 8 | b2 & 0xFF) + 1;
                    break;
                }
                default: {
                    throw UndertowClientMessages.MESSAGES.unknownAjpMessageType(packetType);
                }
            }
        } else {
            chunkRemaining = this.state & STATE_MASK;
        }
        if (chunkRemaining <= 0L) {
            this.terminateReads();
            throw new RuntimeException("error " + chunkRemaining + " FLAG: " + val);
        }
        int limit = dst.limit();
        try {
            int read;
            if ((long)dst.remaining() > chunkRemaining) {
                dst.limit((int)((long)dst.position() + chunkRemaining));
            }
            if ((chunkRemaining -= (long)(read = ((StreamSourceConduit)this.next).read(dst))) == 0L) {
                --read;
                dst.position(dst.position() - 1);
                headerBuffer.clear();
            }
            this.state = this.state & (STATE_MASK ^ 0xFFFFFFFFFFFFFFFFL) | chunkRemaining;
            int n = read;
            return n;
        }
        finally {
            dst.limit(limit);
        }
    }

    private void handleFinish() {
        if (Bits.allAreClear(this.state, Long.MIN_VALUE)) {
            this.state |= Long.MIN_VALUE;
            this.finishListener.handleEvent(this);
            this.ajpClientRequestConduit.setRequestDone();
        }
    }

    private boolean headerRead() {
        boolean headerRead = false;
        if (this.headerBuffer.remaining() == 0) {
            headerRead = true;
        } else if (this.headerBuffer.remaining() == 1 && this.headerBuffer.get(4) != 3) {
            headerRead = true;
        }
        return headerRead;
    }

    @Override
    public void awaitReadable() throws IOException {
        ((StreamSourceConduit)this.next).awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
    }
}

