/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.http.HttpClientConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class HttpClientProvider
implements ClientProvider {
    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("http", "https"));
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, final URI uri, XnioWorker worker, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        if (uri.getScheme().equals("https") && ssl == null) {
            throw UndertowMessages.MESSAGES.sslWasNull();
        }
        worker.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                HttpClientProvider.this.handleConnected(connection, listener, uri, ssl, bufferPool, options);
            }
        }, options).addNotifier(new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        }, null);
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, final URI uri, XnioIoThread ioThread, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        if (uri.getScheme().equals("https") && ssl == null) {
            throw UndertowMessages.MESSAGES.sslWasNull();
        }
        ioThread.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort()), (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                HttpClientProvider.this.handleConnected(connection, listener, uri, ssl, bufferPool, options);
            }
        }, options).addNotifier(new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        }, null);
    }

    private void handleConnected(StreamConnection connection, ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (uri.getScheme().equals("https")) {
            listener.failed(new IOException("ssl not implemented yet"));
        } else {
            listener.completed(new HttpClientConnection(connection, options, bufferPool));
        }
    }
}

