/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.util.DefaultClassIntrospector;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import org.xnio.ByteBufferSlicePool;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowContainerProvider
extends ContainerProvider {
    private static final RuntimePermission PERMISSION = new RuntimePermission("io.undertow.websockets.jsr.MODIFY_WEBSOCKET_CONTAINER");
    private static final Map<ClassLoader, WebSocketContainer> webSocketContainers = new ConcurrentHashMap<ClassLoader, WebSocketContainer>();
    private static volatile WebSocketContainer defaultContainer;
    private static volatile boolean defaultContainerDisabled;

    @Override
    protected WebSocketContainer getContainer() {
        ClassLoader tccl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        WebSocketContainer webSocketContainer = webSocketContainers.get(tccl);
        if (webSocketContainer == null) {
            return this.getDefaultContainer();
        }
        return webSocketContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketContainer getDefaultContainer() {
        if (defaultContainerDisabled) {
            return null;
        }
        if (defaultContainer != null) {
            return defaultContainer;
        }
        Class<UndertowContainerProvider> clazz = UndertowContainerProvider.class;
        synchronized (UndertowContainerProvider.class) {
            if (defaultContainer == null) {
                try {
                    XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.create(Options.THREAD_DAEMON, true));
                    ByteBufferSlicePool buffers = new ByteBufferSlicePool(1024, 10240);
                    defaultContainer = new ServerWebSocketContainer((ClassIntrospecter)DefaultClassIntrospector.INSTANCE, UndertowContainerProvider.class.getClassLoader(), worker, buffers, new CompositeThreadSetupAction(Collections.emptyList()), false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultContainer;
        }
    }

    public static void addContainer(ClassLoader classLoader, WebSocketContainer webSocketContainer) {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(PERMISSION);
        }
        webSocketContainers.put(classLoader, webSocketContainer);
    }

    public static void removeContainer(ClassLoader classLoader) {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(PERMISSION);
        }
        webSocketContainers.remove(classLoader);
    }

    public static void disableDefaultContainer() {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(PERMISSION);
        }
        defaultContainerDisabled = true;
    }

    static {
        defaultContainerDisabled = false;
    }
}

