/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.DefaultPongMessage;
import io.undertow.websockets.jsr.OrderedExecutor;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.PongMessage;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.xnio.Buffers;
import org.xnio.Pooled;

public class AnnotatedEndpoint
extends Endpoint {
    private final InstanceHandle<?> instance;
    private Executor executor;
    private final BoundMethod webSocketOpen;
    private final BoundMethod webSocketClose;
    private final BoundMethod webSocketError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryMessage;
    private final BoundMethod pongMessage;

    AnnotatedEndpoint(InstanceHandle<?> instance, BoundMethod webSocketOpen, BoundMethod webSocketClose, BoundMethod webSocketError, BoundMethod textMessage, BoundMethod binaryMessage, BoundMethod pongMessage) {
        this.instance = instance;
        this.webSocketOpen = webSocketOpen;
        this.webSocketClose = webSocketClose;
        this.webSocketError = webSocketError;
        this.textMessage = textMessage;
        this.binaryMessage = binaryMessage;
        this.pongMessage = pongMessage;
    }

    @Override
    public void onOpen(Session session, EndpointConfig endpointConfiguration) {
        this.executor = new OrderedExecutor(((UndertowSession)session).getWebSocketChannel().getWorker());
        UndertowSession s = (UndertowSession)session;
        boolean partialText = this.textMessage == null || this.textMessage.hasParameterType(Boolean.TYPE) && !this.textMessage.getMessageType().equals(Boolean.TYPE);
        boolean partialBinary = this.binaryMessage == null || this.binaryMessage.hasParameterType(Boolean.TYPE) && !this.binaryMessage.getMessageType().equals(Boolean.TYPE);
        s.setReceiveListener(new AnnotatedEndpointFrameHandler((UndertowSession)session, partialText, partialBinary));
        if (this.webSocketOpen != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(EndpointConfig.class, endpointConfiguration);
            params.put(Map.class, session.getPathParameters());
            this.invokeMethod(params, this.webSocketOpen, s);
        }
    }

    private void invokeMethod(final Map<Class<?>, Object> params, final BoundMethod method, final UndertowSession session) {
        session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                try {
                    method.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                }
                catch (DecodeException e) {
                    AnnotatedEndpoint.this.onError(session, e);
                }
            }
        });
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        if (this.webSocketClose != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(Map.class, session.getPathParameters());
            params.put(CloseReason.class, closeReason);
            this.invokeMethod(params, this.webSocketClose, (UndertowSession)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Session session, Throwable thr) {
        try {
            if (this.webSocketError != null) {
                final HashMap<Class<Map>, Object> params = new HashMap<Class<Map>, Object>();
                params.put(Session.class, session);
                params.put(Throwable.class, thr);
                params.put(Map.class, session.getPathParameters());
                ((UndertowSession)session).getContainer().invokeEndpointMethod(this.executor, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AnnotatedEndpoint.this.webSocketError.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (DecodeException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
        finally {
            ((UndertowSession)session).forceClose();
        }
    }

    private class AnnotatedEndpointFrameHandler
    extends AbstractReceiveListener {
        BufferedTextMessage bufferedTextMessage;
        private final UndertowSession session;
        private final boolean partialText;
        private final boolean partialBinary;
        private final SendHandler errorReportingSendHandler = new SendHandler(){

            @Override
            public void onResult(SendResult result) {
                if (!result.isOK()) {
                    AnnotatedEndpoint.this.onError(null, result.getException());
                }
            }
        };

        public AnnotatedEndpointFrameHandler(UndertowSession session, boolean partialText, boolean partialBinary) {
            this.session = session;
            this.partialText = partialText;
            this.partialBinary = partialBinary;
        }

        @Override
        protected long getMaxTextBufferSize() {
            if (AnnotatedEndpoint.this.textMessage != null) {
                return AnnotatedEndpoint.this.textMessage.getMaxMessageSize();
            }
            return 1L;
        }

        @Override
        protected long getMaxPongBufferSize() {
            if (AnnotatedEndpoint.this.pongMessage != null) {
                return AnnotatedEndpoint.this.pongMessage.getMaxMessageSize();
            }
            return -1L;
        }

        @Override
        protected long getMaxBinaryBufferSize() {
            if (AnnotatedEndpoint.this.binaryMessage != null) {
                return AnnotatedEndpoint.this.binaryMessage.getMaxMessageSize();
            }
            return 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
            Pooled<ByteBuffer[]> data = message.getData();
            ByteBuffer buffer = WebSockets.mergeBuffers(data.getResource());
            CloseMessage cm = new CloseMessage(buffer);
            data.free();
            try {
                if (AnnotatedEndpoint.this.webSocketClose != null) {
                    try {
                        HashMap<Class<CloseReason>, Object> params = new HashMap<Class<CloseReason>, Object>();
                        params.put(Session.class, this.session);
                        params.put(Map.class, this.session.getPathParameters());
                        params.put(CloseReason.class, new CloseReason(CloseReason.CloseCodes.getCloseCode(cm.getCode()), cm.getReason()));
                        AnnotatedEndpoint.this.invokeMethod(params, AnnotatedEndpoint.this.webSocketClose, this.session);
                    }
                    catch (Exception e) {
                        AnnotatedEndpoint.this.onError(this.session, e);
                    }
                }
                AnnotatedEndpoint.this.executor.execute(new Runnable(buffer, channel){
                    final /* synthetic */ ByteBuffer val$buffer;
                    final /* synthetic */ WebSocketChannel val$channel;
                    {
                        this.val$buffer = byteBuffer;
                        this.val$channel = webSocketChannel;
                    }

                    @Override
                    public void run() {
                        WebSockets.sendClose(this.val$buffer.duplicate(), this.val$channel, null);
                    }
                });
            }
            catch (Throwable throwable) {
                AnnotatedEndpoint.this.executor.execute(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onFullPongMessage(WebSocketChannel channel, BufferedBinaryMessage bufferedBinaryMessage) throws IOException {
            if (AnnotatedEndpoint.this.pongMessage == null) {
                return;
            }
            Pooled<ByteBuffer[]> pooled = bufferedBinaryMessage.getData();
            try {
                PongMessage message = DefaultPongMessage.create(WebSockets.mergeBuffers(pooled.getResource()));
                final HashMap<Class<PongMessage>, Object> params = new HashMap<Class<PongMessage>, Object>();
                params.put(Session.class, this.session);
                params.put(Map.class, this.session.getPathParameters());
                params.put(PongMessage.class, message);
                this.session.getContainer().invokeEndpointMethod(AnnotatedEndpoint.this.executor, new Runnable(){

                    @Override
                    public void run() {
                        Object result;
                        try {
                            result = AnnotatedEndpoint.this.pongMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (Exception e) {
                            AnnotatedEndpoint.this.onError(AnnotatedEndpointFrameHandler.this.session, e);
                            return;
                        }
                        AnnotatedEndpointFrameHandler.this.sendResult(result);
                    }
                });
            }
            finally {
                pooled.free();
            }
        }

        @Override
        protected void onError(WebSocketChannel channel, Throwable error) {
            AnnotatedEndpoint.this.onError(this.session, error);
        }

        @Override
        protected void onText(WebSocketChannel webSocketChannel, final StreamSourceFrameChannel messageChannel) throws IOException {
            if (!this.partialText) {
                super.onText(webSocketChannel, messageChannel);
            } else {
                if (this.bufferedTextMessage == null) {
                    this.bufferedTextMessage = new BufferedTextMessage(false);
                }
                this.bufferedTextMessage.read(messageChannel, new WebSocketCallback<BufferedTextMessage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete(WebSocketChannel channel, BufferedTextMessage context) {
                        try {
                            AnnotatedEndpointFrameHandler.this.handleTextMessage(context, context.isComplete());
                        }
                        finally {
                            if (messageChannel.isFinalFragment()) {
                                AnnotatedEndpointFrameHandler.this.bufferedTextMessage = null;
                            }
                        }
                    }

                    @Override
                    public void onError(WebSocketChannel channel, BufferedTextMessage context, Throwable throwable) {
                        AnnotatedEndpoint.this.onError(AnnotatedEndpointFrameHandler.this.session, throwable);
                        AnnotatedEndpointFrameHandler.this.bufferedTextMessage = null;
                    }
                });
            }
        }

        @Override
        protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
            this.handleTextMessage(message, true);
        }

        private void handleTextMessage(BufferedTextMessage message, boolean finalFragment) {
            Object messageObject;
            if (AnnotatedEndpoint.this.textMessage == null) {
                return;
            }
            String data = message.getData();
            if (AnnotatedEndpoint.this.textMessage.isDecoderRequired()) {
                try {
                    messageObject = this.session.getEncoding().decodeText(AnnotatedEndpoint.this.textMessage.getMessageType(), data);
                }
                catch (DecodeException e) {
                    AnnotatedEndpoint.this.onError(this.session, e);
                    return;
                }
            } else {
                messageObject = AnnotatedEndpoint.this.textMessage.getMessageType().equals(Reader.class) ? new StringReader(data) : data;
            }
            final HashMap params = new HashMap();
            params.put(Session.class, this.session);
            params.put(Map.class, this.session.getPathParameters());
            params.put(AnnotatedEndpoint.this.textMessage.getMessageType(), messageObject);
            params.put(Boolean.TYPE, finalFragment);
            this.session.getContainer().invokeEndpointMethod(AnnotatedEndpoint.this.executor, new Runnable(){

                @Override
                public void run() {
                    Object result;
                    try {
                        result = AnnotatedEndpoint.this.textMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                    }
                    catch (Exception e) {
                        AnnotatedEndpoint.this.onError(AnnotatedEndpointFrameHandler.this.session, e);
                        return;
                    }
                    AnnotatedEndpointFrameHandler.this.sendResult(result);
                }
            });
        }

        private void sendResult(Object result) {
            if (result != null) {
                if (result instanceof String) {
                    this.session.getAsyncRemote().sendText((String)result, this.errorReportingSendHandler);
                } else if (result instanceof byte[]) {
                    this.session.getAsyncRemote().sendBinary(ByteBuffer.wrap((byte[])result), this.errorReportingSendHandler);
                } else if (result instanceof ByteBuffer) {
                    this.session.getAsyncRemote().sendBinary((ByteBuffer)result, this.errorReportingSendHandler);
                } else {
                    this.session.getAsyncRemote().sendObject(result, this.errorReportingSendHandler);
                }
            }
        }

        @Override
        protected void onBinary(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
            if (!this.partialBinary) {
                super.onBinary(webSocketChannel, messageChannel);
            } else {
                BufferedBinaryMessage buffered = new BufferedBinaryMessage(this.session.getMaxBinaryMessageBufferSize(), false);
                buffered.read(messageChannel, new WebSocketCallback<BufferedBinaryMessage>(){

                    @Override
                    public void complete(WebSocketChannel channel, BufferedBinaryMessage context) {
                        AnnotatedEndpointFrameHandler.this.handleBinaryMessage(context, context.isComplete());
                    }

                    @Override
                    public void onError(WebSocketChannel channel, BufferedBinaryMessage context, Throwable throwable) {
                        AnnotatedEndpoint.this.onError(AnnotatedEndpointFrameHandler.this.session, throwable);
                    }
                });
            }
        }

        @Override
        protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
            this.handleBinaryMessage(message, true);
        }

        protected byte[] toArray(ByteBuffer ... payload) {
            ByteBuffer buf;
            if (payload.length == 1 && (buf = payload[0]).hasArray() && buf.arrayOffset() == 0 && buf.position() == 0) {
                return buf.array();
            }
            int size = (int)Buffers.remaining(payload);
            byte[] data = new byte[size];
            int pos = 0;
            for (ByteBuffer buf2 : payload) {
                int toWrite = buf2.remaining();
                buf2.get(data, pos, toWrite);
                pos += toWrite;
            }
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleBinaryMessage(BufferedBinaryMessage message, boolean finalFragment) {
            if (AnnotatedEndpoint.this.binaryMessage == null) {
                message.getData().free();
                return;
            }
            Pooled<ByteBuffer[]> pooled = message.getData();
            try {
                final HashMap params = new HashMap();
                params.put(Session.class, this.session);
                params.put(Map.class, this.session.getPathParameters());
                if (AnnotatedEndpoint.this.binaryMessage.isDecoderRequired()) {
                    try {
                        params.put(AnnotatedEndpoint.this.binaryMessage.getMessageType(), this.session.getEncoding().decodeBinary(AnnotatedEndpoint.this.binaryMessage.getMessageType(), this.toArray(pooled.getResource())));
                    }
                    catch (Exception e) {
                        AnnotatedEndpoint.this.onError(this.session, e);
                        pooled.free();
                        return;
                    }
                }
                if (AnnotatedEndpoint.this.binaryMessage.getMessageType() == ByteBuffer.class) {
                    params.put(ByteBuffer.class, WebSockets.mergeBuffers(pooled.getResource()));
                } else if (AnnotatedEndpoint.this.binaryMessage.getMessageType() == byte[].class) {
                    params.put(byte[].class, this.toArray(pooled.getResource()));
                } else if (AnnotatedEndpoint.this.binaryMessage.getMessageType() == InputStream.class) {
                    params.put(InputStream.class, new ByteArrayInputStream(this.toArray(pooled.getResource())));
                } else {
                    try {
                        params.put(AnnotatedEndpoint.this.binaryMessage.getMessageType(), this.session.getEncoding().decodeBinary(AnnotatedEndpoint.this.binaryMessage.getMessageType(), this.toArray(pooled.getResource())));
                    }
                    catch (DecodeException e) {
                        AnnotatedEndpoint.this.onError(this.session, e);
                        pooled.free();
                        return;
                    }
                    throw new RuntimeException("decoders are not implemented yet");
                }
                params.put(Boolean.TYPE, finalFragment);
                this.session.getContainer().invokeEndpointMethod(AnnotatedEndpoint.this.executor, new Runnable(){

                    @Override
                    public void run() {
                        Object result;
                        try {
                            result = AnnotatedEndpoint.this.binaryMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (Exception e) {
                            AnnotatedEndpoint.this.onError(AnnotatedEndpointFrameHandler.this.session, e);
                            return;
                        }
                        AnnotatedEndpointFrameHandler.this.sendResult(result);
                    }
                });
            }
            finally {
                pooled.free();
            }
        }
    }
}

