/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class VHost {
    private final String name;
    private final String JVMRoute;
    private long id;
    private final List<String> aliases;

    VHost(VHostBuilder b) {
        this.name = b.name;
        this.JVMRoute = b.JVMRoute;
        this.aliases = Collections.unmodifiableList(new ArrayList(b.aliases));
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getName() {
        return this.name;
    }

    public String getJVMRoute() {
        return this.JVMRoute;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public static VHostBuilder builder() {
        return new VHostBuilder();
    }

    public static class VHostBuilder {
        private String name;
        private String JVMRoute;
        private long id;
        private final List<String> aliases = new ArrayList<String>();

        VHostBuilder() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setJVMRoute(String JVMRoute) {
            this.JVMRoute = JVMRoute;
        }

        public void setId(long id) {
            this.id = id;
        }

        public boolean addAliases(Collection<String> c) {
            return this.aliases.addAll(c);
        }

        public boolean removeAlias(String alias) {
            return this.aliases.remove(alias);
        }

        public VHost build() {
            return new VHost(this);
        }
    }
}

