/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyControlFrameStreamSinkChannel;
import io.undertow.spdy.SpdyProtocolUtils;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;

class SpdyPingStreamSinkChannel
extends SpdyControlFrameStreamSinkChannel {
    private final int id;

    protected SpdyPingStreamSinkChannel(SpdyChannel channel, int id) {
        super(channel);
        this.id = id;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(12);
        int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 6;
        SpdyProtocolUtils.putInt(buf, firstInt);
        SpdyProtocolUtils.putInt(buf, 4);
        SpdyProtocolUtils.putInt(buf, this.id);
        return new SendFrameHeader(new ImmediatePooled<ByteBuffer>(buf));
    }
}

