/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Hpack;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HpackEncoder
extends Hpack {
    private int currentBitPos;
    private long headersIterator = -1L;
    private HeaderMap currentHeaders;
    private static final Map<HttpString, StaticTableEntry> ENCODING_STATIC_TABLE;
    private int tableSize;
    private int extraData;

    public HpackEncoder(int tableSize) {
        this.tableSize = tableSize;
    }

    public State encode(HeaderMap headers, ByteBuffer target) {
        if (target.remaining() < 3) {
            return State.UNDERFLOW;
        }
        long it = this.headersIterator;
        if (this.headersIterator == -1L) {
            this.currentBitPos = 0;
            it = headers.fastIterate();
            this.currentHeaders = headers;
        } else {
            if (headers != this.currentHeaders) {
                throw new IllegalStateException();
            }
            if (this.currentBitPos > 0) {
                target.put((byte)this.extraData);
            }
        }
        while (it != -1L) {
            HeaderValues values = headers.fiCurrent(it);
            for (int i = 0; i < values.size(); ++i) {
                int required = 11 + values.getHeaderName().length();
                StaticTableEntry staticTable = ENCODING_STATIC_TABLE.get(values.getHeaderName());
                String val = values.get(i);
                if (target.remaining() < (required += 1 + val.length())) {
                    this.headersIterator = it;
                    this.currentBitPos = 0;
                    return State.UNDERFLOW;
                }
                if (staticTable == null) {
                    target.put((byte)0);
                    target.put((byte)0);
                    HpackEncoder.encodeInteger(target, values.getHeaderName().length(), 7);
                    values.getHeaderName().appendTo(target);
                } else {
                    target.put((byte)0);
                    HpackEncoder.encodeInteger(target, staticTable.pos, 4);
                }
                target.put((byte)0);
                HpackEncoder.encodeInteger(target, val.length(), 7);
                for (int j = 0; j < val.length(); ++j) {
                    target.put((byte)val.charAt(j));
                }
            }
            it = headers.fiNext(it);
        }
        this.headersIterator = -1L;
        return State.COMPLETE;
    }

    static int pushBits(ByteBuffer buffer, int value, int n, int currentBitPos) {
        int forThisByte;
        int bitsLeft = n;
        if (currentBitPos != 0) {
            int rem = 8 - currentBitPos;
            int forThisByte2 = n > rem ? rem : n;
            int toPush = value >> n - forThisByte2;
            int shift = 8 - (currentBitPos + forThisByte2);
            int pos = buffer.position() - 1;
            buffer.put(pos, (byte)(buffer.get(pos) | toPush << shift));
            if ((bitsLeft -= forThisByte2) == 0) {
                int newPos = currentBitPos + n;
                return newPos == 8 ? 0 : newPos;
            }
        }
        do {
            forThisByte = bitsLeft > 8 ? 8 : bitsLeft;
            int toPush = value >> bitsLeft - forThisByte;
            int shift = 8 - forThisByte;
            buffer.put((byte)(toPush << shift));
        } while ((bitsLeft -= forThisByte) != 0);
        return forThisByte;
    }

    static {
        HashMap<HttpString, StaticTableEntry> map = new HashMap<HttpString, StaticTableEntry>();
        for (int i = 1; i < STATIC_TABLE.length; ++i) {
            Hpack.HeaderField m = STATIC_TABLE[i];
            map.put(m.name, new StaticTableEntry(m.value, i));
        }
        ENCODING_STATIC_TABLE = Collections.unmodifiableMap(map);
    }

    static final class StaticTableEntry {
        final String value;
        final int pos;

        private StaticTableEntry(String value, int pos) {
            this.value = value;
            this.pos = pos;
        }
    }

    public static enum State {
        COMPLETE,
        UNDERFLOW;

    }
}

