/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyStreamSourceChannel;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public class SpdySynReplyStreamSourceChannel
extends SpdyStreamSourceChannel {
    private final HeaderMap headers;
    private final int streamId;
    private volatile HeaderMap newHeaders = null;
    private int flowControlWindow;
    private boolean rst = false;

    SpdySynReplyStreamSourceChannel(SpdyChannel framedChannel, Pooled<ByteBuffer> data, long frameDataRemaining, HeaderMap headers, int streamId) {
        super(framedChannel, data, frameDataRemaining);
        this.headers = headers;
        this.streamId = streamId;
        this.flowControlWindow = framedChannel.getInitialWindowSize();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.handleNewHeaders();
        int read = super.read(dst);
        this.updateFlowControlWindow(read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts, offset, length);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(count, throughBuffer, streamSinkChannel);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(position, count, target);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewHeaders() {
        if (this.newHeaders != null) {
            SpdySynReplyStreamSourceChannel spdySynReplyStreamSourceChannel = this;
            synchronized (spdySynReplyStreamSourceChannel) {
                for (HeaderValues header : this.newHeaders) {
                    this.headers.addAll(header.getHeaderName(), header);
                }
            }
            this.newHeaders = null;
        }
    }

    synchronized void addNewHeaders(HeaderMap headers) {
        if (this.newHeaders != null) {
            this.newHeaders = headers;
        } else {
            for (HeaderValues header : headers) {
                this.newHeaders.addAll(header.getHeaderName(), header);
            }
        }
    }

    private void updateFlowControlWindow(int read) {
        if (read == 0) {
            return;
        }
        this.flowControlWindow -= read;
        SpdyChannel spdyChannel = this.getSpdyChannel();
        spdyChannel.updateReceiveFlowControlWindow(read);
        int initialWindowSize = spdyChannel.getInitialWindowSize();
        if (this.flowControlWindow < initialWindowSize / 2) {
            int delta = initialWindowSize - this.flowControlWindow;
            this.flowControlWindow += delta;
            spdyChannel.sendUpdateWindowSize(this.streamId, delta);
        }
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public int getStreamId() {
        return this.streamId;
    }

    @Override
    void rstStream() {
        if (this.rst) {
            return;
        }
        this.rst = true;
        this.markStreamBroken();
        this.getSpdyChannel().sendRstStream(this.streamId, 3);
    }

    @Override
    protected void channelForciblyClosed() {
        this.rstStream();
    }
}

