/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooled;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSinkChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSinkChannel {
    private static final Pooled<ByteBuffer> EMPTY_BYTE_BUFFER = new ImmediatePooled<ByteBuffer>(ByteBuffer.allocateDirect(0));
    private Pooled<ByteBuffer> buffer;
    private final C channel;
    private final ChannelListener.SimpleSetter<S> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<S> closeSetter = new ChannelListener.SimpleSetter();
    private final Object lock = new Object();
    private volatile int state = 0;
    private volatile boolean readyForFlush;
    private volatile boolean fullyFlushed;
    private volatile boolean finalFrameQueued;
    private volatile boolean broken;
    private volatile int waiterCount = 0;
    private SendFrameHeader header;
    private Pooled<ByteBuffer> trailer;
    private static final int STATE_CLOSED = 1;
    private static final int STATE_WRITES_RESUMED = 2;
    private static final int STATE_WRITES_SHUTDOWN = 4;
    private static final int STATE_IN_LISTENER_LOOP = 8;
    private static final int STATE_FIRST_DATA_WRITTEN = 16;

    protected AbstractFramedStreamSinkChannel(C channel) {
        this.channel = channel;
        this.buffer = ((AbstractFramedChannel)channel).getBufferPool().allocate();
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, this);
    }

    @Override
    public void suspendWrites() {
        this.state &= 0xFFFFFFFD;
    }

    final SendFrameHeader getFrameHeader() throws IOException {
        if (this.header == null) {
            this.header = this.createFrameHeader();
            if (this.header == null) {
                this.header = new SendFrameHeader(0, null);
            }
        }
        return this.header;
    }

    protected SendFrameHeader createFrameHeader() throws IOException {
        return null;
    }

    final ByteBuffer getFrameFooter() {
        if (this.trailer == null) {
            this.trailer = this.createFrameFooter();
            if (this.trailer == null) {
                this.trailer = EMPTY_BYTE_BUFFER;
            }
        }
        return this.trailer.getResource();
    }

    protected Pooled<ByteBuffer> createFrameFooter() {
        return null;
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.anyAreSet(this.state, 2);
    }

    @Override
    public void wakeupWrites() {
        this.resumeWritesInternal(true);
    }

    @Override
    public void resumeWrites() {
        this.resumeWritesInternal(false);
    }

    protected void resumeWritesInternal(boolean wakeup) {
        boolean alreadyResumed = Bits.anyAreSet(this.state, 2);
        if (!wakeup && alreadyResumed) {
            return;
        }
        this.state |= 2;
        if (this.readyForFlush && !wakeup) {
            return;
        }
        if (!Bits.anyAreSet(this.state, 8)) {
            this.state |= 8;
            this.getIoThread().execute(new Runnable(){
                int loopCount = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ChannelListener listener = AbstractFramedStreamSinkChannel.this.getWriteListener();
                        if (listener == null || !AbstractFramedStreamSinkChannel.this.isWriteResumed()) {
                            return;
                        }
                        if (this.loopCount++ == 100) {
                            UndertowLogger.ROOT_LOGGER.listenerNotProgressing();
                            IoUtils.safeClose((Closeable)AbstractFramedStreamSinkChannel.this);
                            return;
                        }
                        ChannelListeners.invokeChannelListener(AbstractFramedStreamSinkChannel.this, listener);
                        if (Bits.allAreSet(AbstractFramedStreamSinkChannel.this.state, 2) && Bits.allAreClear(AbstractFramedStreamSinkChannel.this.state, 1) && !AbstractFramedStreamSinkChannel.this.broken && !AbstractFramedStreamSinkChannel.this.readyForFlush && !AbstractFramedStreamSinkChannel.this.fullyFlushed) {
                            AbstractFramedStreamSinkChannel.this.getIoThread().execute(this);
                        }
                    }
                    finally {
                        AbstractFramedStreamSinkChannel.this.state &= -9;
                    }
                }
            });
        }
    }

    @Override
    public void shutdownWrites() throws IOException {
        if (Bits.anyAreSet(this.state, 4) || this.broken) {
            return;
        }
        this.state |= 4;
        this.queueFinalFrame();
    }

    private void queueFinalFrame() throws IOException {
        if (!(this.readyForFlush || this.fullyFlushed || !Bits.allAreClear(this.state, 1) || this.broken || this.finalFrameQueued)) {
            this.readyForFlush = true;
            this.buffer.getResource().flip();
            this.state |= 0x10;
            this.finalFrameQueued = true;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
    }

    protected boolean isFinalFrameQueued() {
        return this.finalFrameQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet(this.state, 1) || this.broken) {
                return;
            }
            if (this.readyForFlush) {
                try {
                    ++this.waiterCount;
                    if (this.readyForFlush && !Bits.anyAreSet(this.state, 1) && !this.broken) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                finally {
                    --this.waiterCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet(this.state, 1) || this.broken) {
                return;
            }
            if (this.readyForFlush) {
                try {
                    ++this.waiterCount;
                    if (this.readyForFlush && !Bits.anyAreSet(this.state, 1) && !this.broken) {
                        this.lock.wait(timeUnit.toMillis(l));
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                finally {
                    --this.waiterCount;
                }
            }
        }
    }

    @Override
    public XnioExecutor getWriteThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public ChannelListener.Setter<? extends S> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends S> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return ((AbstractFramedChannel)this.channel).getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return true;
        }
        if (this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (this.readyForFlush) {
            return false;
        }
        if (this.fullyFlushed) {
            this.state |= 1;
            return true;
        }
        if (Bits.anyAreSet(this.state, 4) && !this.finalFrameQueued) {
            this.queueFinalFrame();
            return false;
        }
        return !Bits.anyAreSet(this.state, 4);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int state = this.state;
        if (this.readyForFlush) {
            return 0L;
        }
        if (Bits.anyAreSet(state, 5) || this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        long copied = Buffers.copy(this.buffer.getResource(), srcs, offset, length);
        if (!this.buffer.getResource().hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int state = this.state;
        if (this.readyForFlush) {
            return 0;
        }
        if (Bits.anyAreSet(state, 5) || this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        int copied = Buffers.copy(this.buffer.getResource(), src);
        if (!this.buffer.getResource().hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.writeFinal(srcs, 0, srcs.length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic(this, src);
    }

    private void handleBufferFull() throws IOException {
        if (!this.readyForFlush) {
            this.readyForFlush = true;
            this.getBuffer().flip();
            this.state |= 0x10;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
    }

    protected abstract boolean isLastFrame();

    public boolean isReadyForFlush() {
        return this.readyForFlush;
    }

    public boolean isWritesShutdown() {
        return Bits.anyAreSet(this.state, 4);
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.fullyFlushed || Bits.anyAreSet(this.state, 1)) {
            return;
        }
        this.state |= 1;
        this.buffer.free();
        this.buffer = null;
        if (this.header != null && this.header.getByteBuffer() != null) {
            this.header.getByteBuffer().free();
        }
        if (this.trailer != null) {
            this.trailer.free();
        }
        if (Bits.anyAreSet(this.state, 16)) {
            this.channelForciblyClosed();
        }
        if (this.isWriteResumed()) {
            ChannelListeners.invokeChannelListener(this.getIoThread(), this, this.getWriteListener());
        }
        this.wakeupWrites();
    }

    protected void channelForciblyClosed() throws IOException {
        if (this.isFirstDataWritten()) {
            ((AbstractFramedChannel)this.getChannel()).markWritesBroken(null);
        }
        this.wakeupWaiters();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    public ByteBuffer getBuffer() {
        return this.buffer.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushComplete() throws IOException {
        try {
            boolean channelClosed;
            int remaining = this.header.getRemainingInBuffer();
            boolean finalFrame = this.finalFrameQueued;
            boolean bl = channelClosed = finalFrame && remaining == 0 && !this.header.isAnotherFrameRequired();
            if (remaining > 0) {
                this.buffer.getResource().limit(this.buffer.getResource().limit() + remaining);
                if (finalFrame) {
                    this.finalFrameQueued = false;
                }
            } else if (this.header.isAnotherFrameRequired()) {
                this.finalFrameQueued = false;
            }
            if (channelClosed) {
                this.fullyFlushed = true;
                this.buffer.free();
                this.buffer = null;
            } else {
                this.buffer.getResource().compact();
            }
            if (this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().free();
            }
            this.trailer.free();
            this.header = null;
            this.trailer = null;
            this.readyForFlush = false;
            if (this.isWriteResumed() && !channelClosed) {
                this.wakeupWrites();
            } else if (this.isWriteResumed()) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, this.getWriteListener());
            }
            ChannelListener<S> closeListener = this.closeSetter.get();
            if (channelClosed && closeListener != null) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, closeListener);
            }
            this.handleFlushComplete(channelClosed);
        }
        finally {
            this.wakeupWaiters();
        }
    }

    protected void handleFlushComplete(boolean finalFrame) {
    }

    protected boolean isFirstDataWritten() {
        return Bits.anyAreSet(this.state, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markBroken() {
        this.broken = true;
        try {
            ChannelListener<S> closeListener;
            ChannelListener<S> writeListener;
            this.wakeupWrites();
            this.wakeupWaiters();
            if (this.isWriteResumed() && (writeListener = this.writeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, writeListener);
            }
            if ((closeListener = this.closeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, closeListener);
            }
        }
        finally {
            if (this.header != null && this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().free();
            }
            if (this.trailer != null) {
                this.trailer.free();
            }
            if (this.buffer != null) {
                this.buffer.free();
            }
        }
    }

    ChannelListener<? super S> getWriteListener() {
        return this.writeSetter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupWaiters() {
        if (this.waiterCount > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public C getChannel() {
        return this.channel;
    }
}

