/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2NoDataStreamSinkChannel;
import io.undertow.protocols.http2.Http2ProtocolUtils;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;

class Http2PingStreamSinkChannel
extends Http2NoDataStreamSinkChannel {
    public static final int HEADER_NO_ACK = 2054;
    public static final int HEADER_ACK = 525825;
    private final byte[] data;
    private final boolean ack;

    protected Http2PingStreamSinkChannel(Http2Channel channel, byte[] data, boolean ack) {
        super(channel);
        if (data.length != 8) {
            throw new IllegalArgumentException(UndertowMessages.MESSAGES.httpPingDataMustBeLength8());
        }
        this.data = data;
        this.ack = ack;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        int firstInt = this.ack ? 525825 : 2054;
        Http2ProtocolUtils.putInt(buf, firstInt);
        buf.put((byte)0);
        Http2ProtocolUtils.putInt(buf, 0);
        for (int i = 0; i < 8; ++i) {
            buf.put(this.data[i]);
        }
        return new SendFrameHeader(new ImmediatePooled<ByteBuffer>(buf));
    }
}

