/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.util.ImmediatePooled;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class BufferedBinaryMessage {
    private final boolean bufferFullMessage;
    private List<Pooled<ByteBuffer>> data = new ArrayList<Pooled<ByteBuffer>>(1);
    private Pooled<ByteBuffer> current;
    private final long maxMessageSize;
    private long currentSize;
    private boolean complete;
    private int frameCount;

    public BufferedBinaryMessage(long maxMessageSize, boolean bufferFullMessage) {
        this.bufferFullMessage = bufferFullMessage;
        this.maxMessageSize = maxMessageSize;
    }

    public BufferedBinaryMessage(boolean bufferFullMessage) {
        this(-1L, bufferFullMessage);
    }

    public void readBlocking(StreamSourceFrameChannel channel) throws IOException {
        if (this.current == null) {
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
        while (true) {
            int res;
            if ((res = channel.read(this.current.getResource())) == -1) {
                this.complete = true;
                return;
            }
            if (res == 0) {
                channel.awaitReadable();
            }
            this.checkMaxSize(channel, res);
            if (this.bufferFullMessage) {
                this.dealWithFullBuffer(channel);
                continue;
            }
            if (!this.current.getResource().hasRemaining()) break;
        }
    }

    private void dealWithFullBuffer(StreamSourceFrameChannel channel) {
        if (!this.current.getResource().hasRemaining()) {
            this.current.getResource().flip();
            this.data.add(this.current);
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
    }

    public void read(StreamSourceFrameChannel channel, final WebSocketCallback<BufferedBinaryMessage> callback) {
        try {
            while (true) {
                int res;
                if (this.current == null) {
                    this.current = channel.getWebSocketChannel().getBufferPool().allocate();
                }
                if ((res = channel.read(this.current.getResource())) == -1) {
                    this.complete = true;
                    callback.complete(channel.getWebSocketChannel(), this);
                    return;
                }
                if (res == 0) {
                    channel.getReadSetter().set(new ChannelListener<StreamSourceFrameChannel>(){

                        @Override
                        public void handleEvent(StreamSourceFrameChannel channel) {
                            if (BufferedBinaryMessage.this.complete) {
                                return;
                            }
                            try {
                                while (true) {
                                    int res;
                                    if (BufferedBinaryMessage.this.current == null) {
                                        BufferedBinaryMessage.this.current = channel.getWebSocketChannel().getBufferPool().allocate();
                                    }
                                    if ((res = channel.read((ByteBuffer)BufferedBinaryMessage.this.current.getResource())) == -1) {
                                        BufferedBinaryMessage.this.complete = true;
                                        channel.suspendReads();
                                        callback.complete(channel.getWebSocketChannel(), BufferedBinaryMessage.this);
                                        return;
                                    }
                                    if (res == 0) {
                                        return;
                                    }
                                    BufferedBinaryMessage.this.checkMaxSize(channel, res);
                                    if (BufferedBinaryMessage.this.bufferFullMessage) {
                                        BufferedBinaryMessage.this.dealWithFullBuffer(channel);
                                        continue;
                                    }
                                    if (!((ByteBuffer)BufferedBinaryMessage.this.current.getResource()).hasRemaining()) {
                                        callback.complete(channel.getWebSocketChannel(), BufferedBinaryMessage.this);
                                        continue;
                                    }
                                    BufferedBinaryMessage.this.handleNewFrame(channel, callback);
                                }
                            }
                            catch (IOException e) {
                                channel.suspendReads();
                                callback.onError(channel.getWebSocketChannel(), BufferedBinaryMessage.this, e);
                                return;
                            }
                        }
                    });
                    channel.resumeReads();
                    return;
                }
                this.checkMaxSize(channel, res);
                if (this.bufferFullMessage) {
                    this.dealWithFullBuffer(channel);
                    continue;
                }
                if (!this.current.getResource().hasRemaining()) {
                    callback.complete(channel.getWebSocketChannel(), this);
                    continue;
                }
                this.handleNewFrame(channel, callback);
            }
        }
        catch (IOException e) {
            callback.onError(channel.getWebSocketChannel(), this, e);
            return;
        }
    }

    private void handleNewFrame(StreamSourceFrameChannel channel, WebSocketCallback<BufferedBinaryMessage> callback) {
        if (!this.bufferFullMessage && channel.getWebSocketFrameCount() != this.frameCount && this.current != null && !channel.isFinalFragment()) {
            this.frameCount = channel.getWebSocketFrameCount();
            callback.complete(channel.getWebSocketChannel(), this);
        }
    }

    private void checkMaxSize(StreamSourceFrameChannel channel, int res) throws IOException {
        this.currentSize += (long)res;
        if (this.maxMessageSize > 0L && this.currentSize > this.maxMessageSize) {
            WebSockets.sendClose(new CloseMessage(1009, WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize)).toByteBuffer(), channel.getWebSocketChannel(), null);
            throw new IOException(WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize));
        }
    }

    public Pooled<ByteBuffer[]> getData() {
        if (this.current == null) {
            return new ImmediatePooled<ByteBuffer[]>(new ByteBuffer[0]);
        }
        if (this.data.isEmpty()) {
            Pooled<ByteBuffer> current = this.current;
            current.getResource().flip();
            this.current = null;
            ByteBuffer[] data = new ByteBuffer[]{current.getResource()};
            return new PooledByteBufferArray(Collections.singletonList(current), data);
        }
        this.current.getResource().flip();
        this.data.add(this.current);
        this.current = null;
        ByteBuffer[] ret = new ByteBuffer[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            ret[i] = this.data.get(i).getResource();
        }
        List<Pooled<ByteBuffer>> data = this.data;
        this.data = new ArrayList<Pooled<ByteBuffer>>();
        return new PooledByteBufferArray(data, ret);
    }

    public boolean isComplete() {
        return this.complete;
    }

    private static final class PooledByteBufferArray
    implements Pooled<ByteBuffer[]> {
        private final List<Pooled<ByteBuffer>> pooled;
        private final ByteBuffer[] data;

        private PooledByteBufferArray(List<Pooled<ByteBuffer>> pooled, ByteBuffer[] data) {
            this.pooled = pooled;
            this.data = data;
        }

        @Override
        public void discard() {
            for (Pooled<ByteBuffer> item : this.pooled) {
                item.discard();
            }
        }

        @Override
        public void free() {
            for (Pooled<ByteBuffer> item : this.pooled) {
                item.free();
            }
        }

        @Override
        public ByteBuffer[] getResource() throws IllegalStateException {
            return this.data;
        }

        @Override
        public void close() {
            this.free();
        }
    }
}

