/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.FrameHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketSessionRemoteEndpoint;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channel;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;

public final class UndertowSession
implements Session {
    private final String sessionId;
    private final WebSocketChannel webSocketChannel;
    private final FrameHandler frameHandler;
    private final ServerWebSocketContainer container;
    private final Principal user;
    private final WebSocketSessionRemoteEndpoint remote;
    private final Map<String, Object> attrs;
    private final Map<String, List<String>> requestParameterMap;
    private final URI requestUri;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private final InstanceHandle<Endpoint> endpoint;
    private final Encoding encoding;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Set<Session> openSessions;
    private final String subProtocol;
    private final List<Extension> extensions;
    private volatile int maximumBinaryBufferSize = 0;
    private volatile int maximumTextBufferSize = 0;
    private volatile boolean localClose;

    public UndertowSession(WebSocketChannel webSocketChannel, URI requestUri, Map<String, String> pathParameters, Map<String, List<String>> requestParameterMap, EndpointSessionHandler handler, Principal user, InstanceHandle<Endpoint> endpoint, EndpointConfig config, String queryString, Encoding encoding, Set<Session> openSessions, String subProtocol, List<Extension> extensions) {
        this.webSocketChannel = webSocketChannel;
        this.queryString = queryString;
        this.encoding = encoding;
        this.openSessions = openSessions;
        this.container = handler.getContainer();
        this.user = user;
        this.requestUri = requestUri;
        this.requestParameterMap = Collections.unmodifiableMap(requestParameterMap);
        this.pathParameters = Collections.unmodifiableMap(pathParameters);
        this.remote = new WebSocketSessionRemoteEndpoint(webSocketChannel, config, encoding);
        this.endpoint = endpoint;
        webSocketChannel.getCloseSetter().set((ChannelListener<AbstractFramedChannel>)new ChannelListener<Channel>(){

            @Override
            public void handleEvent(Channel channel) {
                UndertowSession.this.close0();
            }
        });
        this.frameHandler = new FrameHandler(this, this.endpoint.getInstance());
        webSocketChannel.getReceiveSetter().set(this.frameHandler);
        this.sessionId = new SecureRandomSessionIdGenerator().createSessionId();
        this.attrs = Collections.synchronizedMap(new HashMap<String, Object>(config.getUserProperties()));
        this.extensions = extensions;
        this.subProtocol = subProtocol;
        webSocketChannel.addCloseTask(new ChannelListener<WebSocketChannel>(){

            @Override
            public void handleEvent(WebSocketChannel channel) {
                channel.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UndertowSession.this.closeInternal(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, null));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    @Override
    public ServerWebSocketContainer getContainer() {
        return this.container;
    }

    @Override
    public synchronized void addMessageHandler(MessageHandler messageHandler) throws IllegalStateException {
        this.frameHandler.addHandler(messageHandler);
    }

    @Override
    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        this.frameHandler.addHandler(clazz, handler);
    }

    @Override
    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        this.frameHandler.addHandler(clazz, handler);
    }

    @Override
    public synchronized Set<MessageHandler> getMessageHandlers() {
        return this.frameHandler.getHandlers();
    }

    @Override
    public synchronized void removeMessageHandler(MessageHandler messageHandler) {
        this.frameHandler.removeHandler(messageHandler);
    }

    public void setReceiveListener(ChannelListener<WebSocketChannel> handler) {
        this.webSocketChannel.getReceiveSetter().set(handler);
    }

    @Override
    public String getProtocolVersion() {
        return this.webSocketChannel.getVersion().toHttpHeaderValue();
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.subProtocol == null ? "" : this.subProtocol;
    }

    @Override
    public boolean isSecure() {
        return this.webSocketChannel.isSecure();
    }

    @Override
    public boolean isOpen() {
        return this.webSocketChannel.isOpen();
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.webSocketChannel.getIdleTimeout();
    }

    @Override
    public void setMaxIdleTimeout(long milliseconds) {
        this.webSocketChannel.setIdleTimeout(milliseconds);
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public void close() throws IOException {
        this.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, null));
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.localClose = true;
        this.closeInternal(closeReason);
    }

    public void closeInternal() throws IOException {
        this.closeInternal(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInternal(CloseReason closeReason) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                try {
                    if (!this.webSocketChannel.isCloseFrameReceived() && !this.webSocketChannel.isCloseFrameSent()) {
                        if (closeReason == null) {
                            this.webSocketChannel.sendClose();
                        } else {
                            WebSockets.sendClose(new CloseMessage(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()).toByteBuffer(), this.webSocketChannel, null);
                        }
                    }
                }
                finally {
                    try {
                        String reason = null;
                        CloseReason.CloseCode code = CloseReason.CloseCodes.NO_STATUS_CODE;
                        if (this.webSocketChannel.getCloseCode() != -1) {
                            reason = this.webSocketChannel.getCloseReason();
                            code = CloseReason.CloseCodes.getCloseCode(this.webSocketChannel.getCloseCode());
                        } else if (closeReason != null) {
                            reason = closeReason.getReasonPhrase();
                            code = closeReason.getCloseCode();
                        }
                        if (!this.webSocketChannel.isCloseInitiatedByRemotePeer() && !this.localClose && code.getCode() != CloseReason.CloseCodes.TOO_BIG.getCode()) {
                            code = CloseReason.CloseCodes.CLOSED_ABNORMALLY;
                        }
                        this.endpoint.getInstance().onClose(this, new CloseReason(code, reason));
                    }
                    catch (Exception e) {
                        this.endpoint.getInstance().onError(this, e);
                    }
                }
            }
            finally {
                this.close0();
            }
        }
    }

    public void forceClose() {
        IoUtils.safeClose((Closeable)this.webSocketChannel);
    }

    @Override
    public URI getRequestURI() {
        return this.requestUri;
    }

    @Override
    public Map<String, List<String>> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.attrs;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.user;
    }

    @Override
    public void setMaxBinaryMessageBufferSize(int i) {
        this.maximumBinaryBufferSize = i;
    }

    @Override
    public int getMaxBinaryMessageBufferSize() {
        return this.maximumBinaryBufferSize;
    }

    @Override
    public void setMaxTextMessageBufferSize(int i) {
        this.maximumTextBufferSize = i;
    }

    @Override
    public int getMaxTextMessageBufferSize() {
        return this.maximumTextBufferSize;
    }

    @Override
    public RemoteEndpoint.Async getAsyncRemote() {
        return this.remote.getAsync();
    }

    @Override
    public RemoteEndpoint.Basic getBasicRemote() {
        return this.remote.getBasic();
    }

    @Override
    public Set<Session> getOpenSessions() {
        return new HashSet<Session>(this.openSessions);
    }

    @Override
    public List<Extension> getNegotiatedExtensions() {
        return this.extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close0() {
        this.openSessions.remove(this);
        try {
            this.endpoint.release();
        }
        finally {
            this.encoding.close();
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public WebSocketChannel getWebSocketChannel() {
        return this.webSocketChannel;
    }
}

