/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

public class IdleTimeoutConduit
implements StreamSinkConduit,
StreamSourceConduit {
    private static final int DELTA = 100;
    private volatile XnioExecutor.Key handle;
    private volatile long idleTimeout;
    private volatile long expireTime = -1L;
    private volatile boolean timedOut = false;
    private final StreamSinkConduit sink;
    private final StreamSourceConduit source;
    private volatile WriteReadyHandler writeReadyHandler;
    private volatile ReadReadyHandler readReadyHandler;
    private final Runnable timeoutCommand = new Runnable(){

        @Override
        public void run() {
            IdleTimeoutConduit.this.handle = null;
            if (IdleTimeoutConduit.this.expireTime == -1L) {
                return;
            }
            long current = System.currentTimeMillis();
            if (current < IdleTimeoutConduit.this.expireTime) {
                IdleTimeoutConduit.this.handle = IdleTimeoutConduit.this.sink.getWriteThread().executeAfter(IdleTimeoutConduit.this.timeoutCommand, IdleTimeoutConduit.this.expireTime - current + 100L, TimeUnit.MILLISECONDS);
                return;
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            IdleTimeoutConduit.this.timedOut = true;
            IdleTimeoutConduit.this.doClose();
            if (IdleTimeoutConduit.this.sink.isWriteResumed() && IdleTimeoutConduit.this.writeReadyHandler != null) {
                IdleTimeoutConduit.this.writeReadyHandler.writeReady();
            }
            if (IdleTimeoutConduit.this.source.isReadResumed() && IdleTimeoutConduit.this.readReadyHandler != null) {
                IdleTimeoutConduit.this.readReadyHandler.readReady();
            }
        }
    };

    protected void doClose() {
        IdleTimeoutConduit.safeClose(this.sink);
        IdleTimeoutConduit.safeClose(this.source);
    }

    public IdleTimeoutConduit(StreamSinkConduit sink, StreamSourceConduit source) {
        this.sink = sink;
        this.source = source;
    }

    private void handleIdleTimeout() throws ClosedChannelException {
        if (this.timedOut) {
            return;
        }
        long idleTimeout = this.idleTimeout;
        if (idleTimeout <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long expireTimeVar = this.expireTime;
        if (expireTimeVar != -1L && currentTime > expireTimeVar) {
            this.timedOut = true;
            this.doClose();
            throw new ClosedChannelException();
        }
        this.expireTime = currentTime + idleTimeout;
        XnioExecutor.Key key = this.handle;
        if (key == null) {
            this.handle = this.sink.getWriteThread().executeAfter(this.timeoutCommand, idleTimeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.handleIdleTimeout();
        int w = this.sink.write(src);
        return w;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.handleIdleTimeout();
        long w = this.sink.write(srcs, offset, length);
        return w;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        this.handleIdleTimeout();
        int w = this.sink.writeFinal(src);
        return w;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.handleIdleTimeout();
        long w = this.sink.writeFinal(srcs, offset, length);
        return w;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        this.handleIdleTimeout();
        long w = this.source.transferTo(position, count, target);
        return w;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        this.handleIdleTimeout();
        long w = this.source.transferTo(count, throughBuffer, target);
        return w;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.handleIdleTimeout();
        long r = this.source.read(dsts, offset, length);
        return r;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.handleIdleTimeout();
        int r = this.source.read(dst);
        return r;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        this.handleIdleTimeout();
        long r = this.sink.transferFrom(src, position, count);
        return r;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        this.handleIdleTimeout();
        long r = this.sink.transferFrom(source, count, throughBuffer);
        return r;
    }

    @Override
    public void suspendReads() {
        this.source.suspendReads();
    }

    @Override
    public void terminateReads() throws IOException {
        this.source.terminateReads();
    }

    @Override
    public boolean isReadShutdown() {
        return this.source.isReadShutdown();
    }

    @Override
    public void resumeReads() {
        this.source.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.source.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.source.wakeupReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.source.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.source.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.source.getReadThread();
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = handler;
        this.source.setReadReadyHandler(handler);
    }

    private static void safeClose(StreamSourceConduit sink) {
        try {
            sink.terminateReads();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void safeClose(StreamSinkConduit sink) {
        try {
            sink.truncateWrites();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        this.sink.terminateWrites();
    }

    @Override
    public boolean isWriteShutdown() {
        return this.sink.isWriteShutdown();
    }

    @Override
    public void resumeWrites() {
        this.sink.resumeWrites();
    }

    @Override
    public void suspendWrites() {
        this.sink.suspendWrites();
    }

    @Override
    public void wakeupWrites() {
        this.sink.wakeupWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.sink.isWriteResumed();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.sink.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.sink.awaitWritable();
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.sink.getWriteThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
        this.sink.setWriteReadyHandler(handler);
    }

    @Override
    public void truncateWrites() throws IOException {
        this.sink.truncateWrites();
    }

    @Override
    public boolean flush() throws IOException {
        return this.sink.flush();
    }

    @Override
    public XnioWorker getWorker() {
        return this.sink.getWorker();
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.expireTime = idleTimeout > 0L ? System.currentTimeMillis() + idleTimeout : -1L;
        if (idleTimeout > 0L && this.handle == null) {
            this.handle = this.sink.getWriteThread().executeAfter(this.timeoutCommand, idleTimeout + 100L, TimeUnit.MILLISECONDS);
        }
    }
}

