/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;

public class WebSockets {
    private static final Charset utf8 = Charset.forName("UTF-8");

    public static void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(utf8));
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.TEXT, wsChannel, callback, -1L);
    }

    public static void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(utf8));
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.TEXT, wsChannel, callback, timeoutmillis);
    }

    public static void sendText(ByteBuffer message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{message}, WebSocketFrameType.TEXT, wsChannel, callback, -1L);
    }

    public static void sendText(ByteBuffer message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(new ByteBuffer[]{message}, WebSocketFrameType.TEXT, wsChannel, callback, timeoutmillis);
    }

    public static void sendTextBlocking(String message, WebSocketChannel wsChannel) throws IOException {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(utf8));
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.TEXT, wsChannel);
    }

    public static void sendTextBlocking(ByteBuffer message, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{message}, WebSocketFrameType.TEXT, wsChannel);
    }

    public static void sendPing(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.PING, wsChannel, callback, -1L);
    }

    public static void sendPing(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.PING, wsChannel, callback, timeoutmillis);
    }

    public static void sendPing(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.PING, wsChannel, callback, -1L);
    }

    public static void sendPing(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(data, WebSocketFrameType.PING, wsChannel, callback, timeoutmillis);
    }

    public static void sendPingBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPingBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPong(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.PONG, wsChannel, callback, -1L);
    }

    public static void sendPong(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.PONG, wsChannel, callback, timeoutmillis);
    }

    public static void sendPong(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.PONG, wsChannel, callback, -1L);
    }

    public static void sendPong(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(data, WebSocketFrameType.PONG, wsChannel, callback, timeoutmillis);
    }

    public static void sendPongBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendPongBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendBinary(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.BINARY, wsChannel, callback, -1L);
    }

    public static void sendBinary(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.BINARY, wsChannel, callback, timeoutmillis);
    }

    public static void sendBinary(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.BINARY, wsChannel, callback, -1L);
    }

    public static void sendBinary(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(data, WebSocketFrameType.BINARY, wsChannel, callback, timeoutmillis);
    }

    public static void sendBinaryBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendBinaryBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendClose(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        CloseMessage sm = new CloseMessage(data);
        WebSockets.sendClose(sm, wsChannel, callback);
    }

    public static void sendClose(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        CloseMessage sm = new CloseMessage(data);
        WebSockets.sendClose(sm, wsChannel, callback);
    }

    public static void sendClose(int code, String reason, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendClose(new CloseMessage(code, reason), wsChannel, callback);
    }

    public static void sendClose(CloseMessage closeMessage, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        wsChannel.setCloseCode(closeMessage.getCode());
        wsChannel.setCloseReason(closeMessage.getReason());
        WebSockets.sendInternal(new ByteBuffer[]{closeMessage.toByteBuffer()}, WebSocketFrameType.CLOSE, wsChannel, callback, -1L);
    }

    public static void sendCloseBlocking(CloseMessage closeMessage, WebSocketChannel wsChannel) throws IOException {
        wsChannel.setCloseReason(closeMessage.getReason());
        wsChannel.setCloseCode(closeMessage.getCode());
        WebSockets.sendBlockingInternal(new ByteBuffer[]{closeMessage.toByteBuffer()}, WebSocketFrameType.CLOSE, wsChannel);
    }

    public static void sendCloseBlocking(int code, String reason, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendCloseBlocking(new CloseMessage(code, reason), wsChannel);
    }

    public static void sendCloseBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendCloseBlocking(new CloseMessage(data), wsChannel);
    }

    public static void sendCloseBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendCloseBlocking(new CloseMessage(data), wsChannel);
    }

    private static void sendInternal(ByteBuffer[] data, WebSocketFrameType type, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        try {
            long totalData = Buffers.remaining(data);
            StreamSinkFrameChannel channel = wsChannel.send(type, totalData);
            WebSockets.sendData(data, wsChannel, callback, channel, null, timeoutmillis);
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onError(wsChannel, null, e);
            }
            IoUtils.safeClose((Closeable)wsChannel);
        }
    }

    private static <T> void sendData(final ByteBuffer[] data, final WebSocketChannel wsChannel, final WebSocketCallback<T> callback, StreamSinkFrameChannel channel, final T context, long timeoutmillis) throws IOException {
        boolean hasRemaining = true;
        while (hasRemaining) {
            long res = channel.write(data);
            hasRemaining = Buffers.hasRemaining(data);
            if (res != 0L || !hasRemaining) continue;
            channel.getWriteSetter().set(new ChannelListener<StreamSinkFrameChannel>(){

                @Override
                public void handleEvent(StreamSinkFrameChannel channel) {
                    do {
                        try {
                            long res = channel.write(data);
                            if (res == 0L) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            WebSockets.handleIoException(channel, e, callback, context, wsChannel);
                            return;
                        }
                    } while (Buffers.hasRemaining(data));
                    channel.suspendWrites();
                    try {
                        WebSockets.flushChannelAsync(wsChannel, callback, channel, context, -1L);
                    }
                    catch (IOException e) {
                        WebSockets.handleIoException(channel, e, callback, context, wsChannel);
                    }
                }
            });
            channel.resumeWrites();
            if (timeoutmillis > 0L) {
                WebSockets.setupTimeout(channel, timeoutmillis);
            }
            return;
        }
        WebSockets.flushChannelAsync(wsChannel, callback, channel, context, timeoutmillis);
    }

    private static <T> void handleIoException(StreamSinkFrameChannel channel, IOException e, WebSocketCallback<T> callback, T context, WebSocketChannel wsChannel) {
        if (callback != null) {
            callback.onError(channel.getWebSocketChannel(), context, e);
        }
        IoUtils.safeClose((Closeable)wsChannel);
        channel.suspendWrites();
    }

    private static <T> void flushChannelAsync(final WebSocketChannel wsChannel, final WebSocketCallback<T> callback, StreamSinkFrameChannel channel, final T context, long timeoutmillis) throws IOException {
        final WebSocketFrameType type = channel.getType();
        channel.shutdownWrites();
        if (!channel.flush()) {
            channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkFrameChannel>(){

                @Override
                public void handleEvent(StreamSinkFrameChannel channel) {
                    if (callback != null) {
                        callback.complete(wsChannel, context);
                    }
                    if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
                        IoUtils.safeClose((Closeable)wsChannel);
                    }
                }
            }, new ChannelExceptionHandler<StreamSinkFrameChannel>(){

                @Override
                public void handleException(StreamSinkFrameChannel channel, IOException exception) {
                    if (callback != null) {
                        callback.onError(wsChannel, context, exception);
                    }
                    if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
                        IoUtils.safeClose((Closeable)wsChannel);
                    }
                }
            }));
            if (timeoutmillis > 0L) {
                WebSockets.setupTimeout(channel, timeoutmillis);
            }
            channel.resumeWrites();
            return;
        }
        if (callback != null) {
            callback.complete(wsChannel, context);
        }
        if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
            IoUtils.safeClose((Closeable)wsChannel);
        }
    }

    private static void setupTimeout(final StreamSinkFrameChannel channel, long timeoutmillis) {
        final XnioExecutor.Key key = channel.getIoThread().executeAfter(new Runnable(){

            @Override
            public void run() {
                if (channel.isOpen()) {
                    IoUtils.safeClose((Closeable)channel);
                }
            }
        }, timeoutmillis, TimeUnit.MILLISECONDS);
        channel.getCloseSetter().set(new ChannelListener<StreamSinkFrameChannel>(){

            @Override
            public void handleEvent(StreamSinkFrameChannel channel) {
                key.remove();
            }
        });
    }

    private static void sendBlockingInternal(ByteBuffer[] data, WebSocketFrameType type, WebSocketChannel wsChannel) throws IOException {
        long totalData = Buffers.remaining(data);
        StreamSinkFrameChannel channel = wsChannel.send(type, totalData);
        for (ByteBuffer buf : data) {
            while (buf.hasRemaining()) {
                int res = channel.write(buf);
                if (res != 0) continue;
                channel.awaitWritable();
            }
        }
        channel.shutdownWrites();
        while (!channel.flush()) {
            channel.awaitWritable();
        }
        if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
            IoUtils.safeClose((Closeable)wsChannel);
        }
    }

    private WebSockets() {
    }

    public static ByteBuffer mergeBuffers(ByteBuffer ... payload) {
        int size = (int)Buffers.remaining(payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }
}

