/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeEvent;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public class FileResourceManager
implements ResourceManager {
    private final List<ResourceChangeListener> listeners = new ArrayList<ResourceChangeListener>();
    private FileSystemWatcher fileSystemWatcher;
    private volatile String base;
    private final long transferMinSize;
    private final boolean caseSensitive;
    private final boolean followLinks;
    private final TreeSet<String> safePaths = new TreeSet();

    public FileResourceManager(File base, long transferMinSize) {
        this(base, transferMinSize, true, false, null);
    }

    public FileResourceManager(File base, long transferMinSize, boolean caseSensitive) {
        this(base, transferMinSize, caseSensitive, false, null);
    }

    public FileResourceManager(File base, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, true, followLinks, safePaths);
    }

    public FileResourceManager(File base, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        this.transferMinSize = transferMinSize;
        this.caseSensitive = caseSensitive;
        this.followLinks = followLinks;
        if (this.followLinks) {
            if (safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(safePaths));
        }
    }

    public File getBase() {
        return new File(this.base);
    }

    public FileResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = null;
        path = p.startsWith("/") ? p.substring(1) : p;
        try {
            File file = new File(this.base, path);
            if (file.exists()) {
                boolean followAll;
                if (path.endsWith("/") && !file.isDirectory()) {
                    return null;
                }
                boolean bl = followAll = this.followLinks && this.safePaths.isEmpty();
                if (!followAll && this.isSymlinkPath(this.base, file)) {
                    if (this.followLinks && this.isSymlinkSafe(file)) {
                        return this.getFileResource(file, path);
                    }
                } else {
                    return this.getFileResource(file, path);
                }
            }
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Invalid path %s", new Object[0]);
            return null;
        }
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return true;
    }

    @Override
    public synchronized void registerResourceChangeListener(ResourceChangeListener listener) {
        this.listeners.add(listener);
        if (this.fileSystemWatcher == null) {
            this.fileSystemWatcher = Xnio.getInstance().createFileSystemWatcher("Watcher for " + this.base, OptionMap.EMPTY);
            this.fileSystemWatcher.watchPath(new File(this.base), new FileChangeCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleChanges(Collection<FileChangeEvent> changes) {
                    FileResourceManager fileResourceManager = FileResourceManager.this;
                    synchronized (fileResourceManager) {
                        ArrayList<ResourceChangeEvent> events = new ArrayList<ResourceChangeEvent>();
                        for (FileChangeEvent change : changes) {
                            if (!change.getFile().getAbsolutePath().startsWith(FileResourceManager.this.base)) continue;
                            String path = change.getFile().getAbsolutePath().substring(FileResourceManager.this.base.length());
                            events.add(new ResourceChangeEvent(path, ResourceChangeEvent.Type.valueOf(change.getType().name())));
                        }
                        for (ResourceChangeListener listener : FileResourceManager.this.listeners) {
                            listener.handleChanges(events);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeResourceChangeListener(ResourceChangeListener listener) {
        this.listeners.remove(listener);
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileSystemWatcher != null) {
            this.fileSystemWatcher.close();
        }
    }

    private boolean isSymlinkPath(String base, File file) throws IOException {
        File root;
        Path rootPath;
        int rootCount;
        Path path = file.toPath();
        int nameCount = path.getNameCount();
        if (nameCount > (rootCount = (rootPath = (root = new File(base)).toPath()).getNameCount())) {
            File f = root;
            for (int i = rootCount; i < nameCount; ++i) {
                if (!Files.isSymbolicLink((f = new File(f, path.getName(i).toString())).toPath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFileSameCase(File file) throws IOException {
        String canonicalName = file.getCanonicalFile().getName();
        if (canonicalName.equals(file.getName())) {
            return true;
        }
        return !canonicalName.equalsIgnoreCase(file.getName());
    }

    private boolean isSymlinkSafe(File file) throws IOException {
        String canonicalPath = file.getCanonicalPath();
        for (String safePath : this.safePaths) {
            if (safePath.length() <= 0) continue;
            if (safePath.charAt(0) == '/') {
                return safePath.length() > 0 && canonicalPath.length() >= safePath.length() && canonicalPath.startsWith(safePath);
            }
            String absSafePath = this.base + '/' + safePath;
            File absSafePathFile = new File(absSafePath);
            String canonicalSafePath = absSafePathFile.getCanonicalPath();
            return canonicalSafePath.length() > 0 && canonicalPath.length() >= canonicalSafePath.length() && canonicalPath.startsWith(canonicalSafePath);
        }
        return false;
    }

    private FileResource getFileResource(File file, String path) throws IOException {
        if (this.caseSensitive) {
            if (this.isFileSameCase(file)) {
                return new FileResource(file, this, path);
            }
            return null;
        }
        return new FileResource(file, this, path);
    }
}

