/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathMatcher;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class PathPrefixPredicate
implements Predicate {
    private final PathMatcher<Boolean> pathMatcher;

    public PathPrefixPredicate(String ... paths) {
        PathMatcher<Boolean> matcher = new PathMatcher<Boolean>();
        for (String path : paths) {
            if (!path.startsWith("/")) {
                matcher.addPrefixPath("/" + path, Boolean.TRUE);
                continue;
            }
            matcher.addPrefixPath(path, Boolean.TRUE);
        }
        this.pathMatcher = matcher;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        Map context;
        boolean matches;
        String relativePath = value.getRelativePath();
        PathMatcher.PathMatch<Boolean> result = this.pathMatcher.match(relativePath);
        boolean bl = matches = result.getValue() == Boolean.TRUE;
        if (matches && (context = (Map)value.getAttachment(PREDICATE_CONTEXT)) != null) {
            context.put("remaining", result.getRemaining());
        }
        return matches;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-prefix";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path = (String[])config.get("path");
            return new PathPrefixPredicate(path);
        }
    }
}

