/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.jsrwebsockets;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.examples.jsrwebsockets.JsrChatWebSocketEndpoint;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import javax.servlet.ServletException;
import org.xnio.ByteBufferSlicePool;

@UndertowExample(value="JSR Web Sockets")
public class JSRWebSocketServer {
    public static void main(String[] args) {
        PathHandler path = Handlers.path();
        Undertow server = Undertow.builder().addHttpListener(8080, "localhost").setHandler(path).build();
        server.start();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(JSRWebSocketServer.class.getClassLoader()).setContextPath("/").addWelcomePage("index.html").setResourceManager(new ClassPathResourceManager(JSRWebSocketServer.class.getClassLoader(), JSRWebSocketServer.class.getPackage())).addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", new WebSocketDeploymentInfo().setBuffers(new ByteBufferSlicePool(100, 1000)).addEndpoint(JsrChatWebSocketEndpoint.class)).setDeploymentName("chat.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            path.addPrefixPath("/", manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }
}

