/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ajp;

import io.undertow.protocols.ajp.AbstractAjpParser;
import io.undertow.protocols.ajp.AjpConstants;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;

class AjpResponseParser
extends AbstractAjpParser {
    public static final AjpResponseParser INSTANCE = new AjpResponseParser();
    private static final int AB = 16706;
    public static final int BEGIN = 0;
    public static final int READING_MAGIC_NUMBER = 1;
    public static final int READING_DATA_SIZE = 2;
    public static final int READING_PREFIX_CODE = 3;
    public static final int READING_STATUS_CODE = 4;
    public static final int READING_REASON_PHRASE = 5;
    public static final int READING_NUM_HEADERS = 6;
    public static final int READING_HEADERS = 7;
    public static final int READING_PERSISTENT_BOOLEAN = 8;
    public static final int READING_BODY_CHUNK_LENGTH = 9;
    public static final int DONE = 10;
    int state;
    byte prefix;
    int dataSize;
    int numHeaders = 0;
    HttpString currentHeader;
    int statusCode;
    String reasonPhrase;
    HeaderMap headers = new HeaderMap();
    int readBodyChunkSize;

    AjpResponseParser() {
    }

    @Override
    public boolean isComplete() {
        return this.state == 10;
    }

    @Override
    public void reset() {
        super.reset();
        this.state = 0;
        this.prefix = 0;
        this.dataSize = 0;
        this.numHeaders = 0;
        this.currentHeader = null;
        this.statusCode = 0;
        this.reasonPhrase = null;
        this.headers = new HeaderMap();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(ByteBuffer buf) throws IOException {
        if (!buf.hasRemaining()) {
            return;
        }
        switch (this.state) {
            case 0: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf);
                if (!result.readComplete) {
                    return;
                }
                if (result.value != 16706) {
                    throw new IOException("Wrong magic number");
                }
            }
            case 2: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf);
                if (!result.readComplete) {
                    this.state = 2;
                    return;
                }
                this.dataSize = result.value;
            }
            case 3: {
                byte prefix;
                if (!buf.hasRemaining()) {
                    this.state = 3;
                    return;
                }
                this.prefix = prefix = buf.get();
                if (prefix == 5) {
                    this.state = 8;
                    break;
                }
                if (prefix == 3) {
                    this.state = 9;
                    break;
                }
                if (prefix != 4 && prefix != 6) {
                    this.state = 10;
                    return;
                }
            }
            case 4: {
                Object result = this.parse16BitInteger(buf);
                if (!((AbstractAjpParser.IntegerHolder)result).readComplete) {
                    this.state = 4;
                    return;
                }
                if (this.prefix != 4) {
                    this.state = 10;
                    this.readBodyChunkSize = ((AbstractAjpParser.IntegerHolder)result).value;
                    return;
                }
                this.statusCode = ((AbstractAjpParser.IntegerHolder)result).value;
            }
            case 5: {
                Object result = this.parseString(buf, false);
                if (!((AbstractAjpParser.StringHolder)result).readComplete) {
                    this.state = 5;
                    return;
                }
                this.reasonPhrase = ((AbstractAjpParser.StringHolder)result).value;
            }
            case 6: {
                Object result = this.parse16BitInteger(buf);
                if (!((AbstractAjpParser.IntegerHolder)result).readComplete) {
                    this.state = 6;
                    return;
                }
                this.numHeaders = ((AbstractAjpParser.IntegerHolder)result).value;
            }
            case 7: {
                for (int readHeaders = this.readHeaders; readHeaders < this.numHeaders; ++readHeaders) {
                    AbstractAjpParser.StringHolder result;
                    if (this.currentHeader == null) {
                        result = this.parseString(buf, true);
                        if (!result.readComplete) {
                            this.state = 7;
                            this.readHeaders = readHeaders;
                            return;
                        }
                        this.currentHeader = result.header != null ? result.header : HttpString.tryFromString(result.value);
                    }
                    result = this.parseString(buf, false);
                    if (!result.readComplete) {
                        this.state = 7;
                        this.readHeaders = readHeaders;
                        return;
                    }
                    this.headers.add(this.currentHeader, result.value);
                    this.currentHeader = null;
                }
                break;
            }
        }
        if (this.state == 8) {
            if (!buf.hasRemaining()) {
                return;
            }
            this.currentIntegerPart = buf.get();
            this.state = 10;
            return;
        }
        if (this.state != 9) {
            this.state = 10;
            return;
        }
        AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf);
        if (result.readComplete) {
            this.currentIntegerPart = result.value;
            this.state = 10;
        }
    }

    @Override
    protected HttpString headers(int offset) {
        return AjpConstants.HTTP_HEADERS_ARRAY[offset];
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public int getReadBodyChunkSize() {
        return this.readBodyChunkSize;
    }
}

