/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.sse;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.util.StringReadChannelListener;
import java.io.IOException;

@UndertowExample(value="Server Sent Events")
public class ServerSentEventsServer {
    public static void main(String[] args) {
        final ServerSentEventHandler sseHandler = Handlers.serverSentEvents();
        HttpHandler chatHandler = new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                new StringReadChannelListener(exchange.getConnection().getBufferPool()){

                    @Override
                    protected void stringDone(String string) {
                        for (ServerSentEventConnection h : sseHandler.getConnections()) {
                            h.send(string);
                        }
                    }

                    @Override
                    protected void error(IOException e) {
                    }
                }.setup(exchange.getRequestChannel());
            }
        };
        Undertow server = Undertow.builder().addHttpListener(8080, "localhost").setHandler(Handlers.path().addPrefixPath("/sse", sseHandler).addPrefixPath("/send", chatHandler).addPrefixPath("/", Handlers.resource(new ClassPathResourceManager(ServerSentEventsServer.class.getClassLoader(), ServerSentEventsServer.class.getPackage())).addWelcomeFiles("index.html"))).build();
        server.start();
    }
}

