/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.nio.channels.SelectionKey;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.WorkerThread;

final class NioTcpServerHandle
extends NioHandle {
    private final Runnable freeTask;
    private final NioTcpServer server;
    private int count;
    private int low;
    private int high;
    private int tokenCount = -1;
    private boolean stopped;

    NioTcpServerHandle(NioTcpServer server, SelectionKey key, WorkerThread thread, int low, int high) {
        super(thread, key);
        this.server = server;
        this.low = low;
        this.high = high;
        this.freeTask = new Runnable(){

            @Override
            public void run() {
                NioTcpServerHandle.this.freeConnection();
            }
        };
    }

    @Override
    void handleReady(int ops) {
        ChannelListeners.invokeChannelListener(this.server, this.server.getAcceptListener());
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)this.server);
    }

    @Override
    void terminated() {
        this.server.invokeCloseHandler();
    }

    Runnable getFreeTask() {
        return this.freeTask;
    }

    void resume() {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            if (!this.stopped && this.server.resumed) {
                super.resume(16);
            }
        } else {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.resume();
                }
            });
        }
    }

    void suspend() {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            if (this.stopped || !this.server.resumed) {
                super.suspend(16);
            }
        } else {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.suspend();
                }
            });
        }
    }

    void channelClosed() {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            this.freeConnection();
        } else {
            thread.execute(this.freeTask);
        }
    }

    void freeConnection() {
        assert (Thread.currentThread() == this.getWorkerThread());
        if (this.count-- <= this.low && this.tokenCount != 0 && this.stopped) {
            this.stopped = false;
            if (this.server.resumed) {
                super.resume(16);
            }
        }
    }

    void setTokenCount(int newCount) {
        WorkerThread workerThread = this.getWorkerThread();
        if (workerThread == Thread.currentThread()) {
            if (this.tokenCount == 0) {
                this.tokenCount = newCount;
                if (this.count <= this.low && this.stopped) {
                    this.stopped = false;
                    if (this.server.resumed) {
                        super.resume(16);
                    }
                }
                return;
            }
            workerThread = workerThread.getNextThread();
        }
        this.setThreadNewCount(workerThread, newCount);
    }

    private void setThreadNewCount(WorkerThread workerThread, final int newCount) {
        final int number = workerThread.getNumber();
        workerThread.execute(new Runnable(){

            @Override
            public void run() {
                NioTcpServerHandle.this.server.getHandle(number).setTokenCount(newCount);
            }
        });
    }

    void initializeTokenCount(final int newCount) {
        WorkerThread workerThread = this.getWorkerThread();
        final int number = workerThread.getNumber();
        if (workerThread == Thread.currentThread()) {
            this.tokenCount = newCount;
            if (newCount == 0) {
                this.stopped = true;
                super.suspend(16);
            }
        } else {
            workerThread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.server.getHandle(number).initializeTokenCount(newCount);
                }
            });
        }
    }

    boolean getConnection() {
        assert (Thread.currentThread() == this.getWorkerThread());
        if (this.stopped) {
            return false;
        }
        if (this.tokenCount != -1 && --this.tokenCount == 0) {
            this.setThreadNewCount(this.getWorkerThread().getNextThread(), this.server.getTokenConnectionCount());
        }
        if (++this.count >= this.high || this.tokenCount == 0) {
            this.stopped = true;
            super.suspend(16);
        }
        return true;
    }

    public void executeSetTask(final int high, final int low) {
        WorkerThread thread = this.getWorkerThread();
        if (thread == Thread.currentThread()) {
            this.high = high;
            this.low = low;
            if (this.count >= high && !this.stopped) {
                this.stopped = true;
                this.suspend();
            } else if (this.count <= low && this.stopped) {
                this.stopped = false;
                if (this.server.resumed) {
                    this.resume();
                }
            }
        } else {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    NioTcpServerHandle.this.executeSetTask(high, low);
                }
            });
        }
    }

    int getConnectionCount() {
        assert (Thread.currentThread() == this.getWorkerThread());
        return this.count;
    }
}

