/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowLogger;
import io.undertow.channels.DelegatingStreamSourceChannel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class ReadTimeoutStreamSourceChannel
extends DelegatingStreamSourceChannel<ReadTimeoutStreamSourceChannel> {
    private int readTimeout;
    private XnioExecutor.Key handle;
    private final Runnable timeoutCommand = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            try {
                if (ReadTimeoutStreamSourceChannel.this.delegate.isReadResumed()) {
                    ChannelListeners.invokeChannelListener(ReadTimeoutStreamSourceChannel.this, ReadTimeoutStreamSourceChannel.this.readSetter.get());
                }
            }
            finally {
                IoUtils.safeClose((Closeable)ReadTimeoutStreamSourceChannel.this.delegate);
            }
        }
    };

    public ReadTimeoutStreamSourceChannel(StreamSourceChannel delegate) {
        super(delegate);
        try {
            Integer timeout = delegate.getOption(Options.READ_TIMEOUT);
            this.readTimeout = timeout != null ? timeout : 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleReadTimeout(long ret) {
        if (ret == -1L) {
            if (this.handle != null) {
                this.handle.remove();
                this.handle = null;
            }
        } else if (this.readTimeout > 0) {
            if (ret == 0L && this.handle == null) {
                this.handle = this.delegate.getIoThread().executeAfter(this.timeoutCommand, this.readTimeout, TimeUnit.MILLISECONDS);
            } else if (ret > 0L && this.handle != null) {
                this.handle.remove();
            }
        }
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long ret = this.delegate.transferTo(position, count, target);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long ret = this.delegate.transferTo(count, throughBuffer, target);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.delegate.read(dsts, offset, length);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        long ret = this.delegate.read(dsts);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int ret = this.delegate.read(dst);
        this.handleReadTimeout(ret);
        return ret;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        T ret = super.setOption(option, value);
        if (option == Options.READ_TIMEOUT) {
            this.readTimeout = (Integer)value;
            if (this.handle != null) {
                this.handle.remove();
                if (this.readTimeout > 0) {
                    this.getReadThread().executeAfter(this.timeoutCommand, this.readTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }
        return ret;
    }

    @Override
    public void shutdownReads() throws IOException {
        super.shutdownReads();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }
}

