/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowLogger;
import io.undertow.channels.DelegatingStreamSinkChannel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class WriteTimeoutStreamSinkChannel
extends DelegatingStreamSinkChannel<WriteTimeoutStreamSinkChannel> {
    private int writeTimeout;
    private XnioExecutor.Key handle;
    private final Runnable timeoutCommand = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            try {
                if (WriteTimeoutStreamSinkChannel.this.delegate.isWriteResumed()) {
                    ChannelListeners.invokeChannelListener(WriteTimeoutStreamSinkChannel.this, WriteTimeoutStreamSinkChannel.this.writeSetter.get());
                }
            }
            finally {
                IoUtils.safeClose((Closeable)WriteTimeoutStreamSinkChannel.this.delegate);
            }
        }
    };

    public WriteTimeoutStreamSinkChannel(StreamSinkChannel delegate) {
        super(delegate);
        try {
            Integer timeout = delegate.getOption(Options.WRITE_TIMEOUT);
            this.writeTimeout = timeout != null ? timeout : 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleWriteTimeout(long ret) {
        if (this.writeTimeout > 0) {
            if (ret == 0L && this.handle == null) {
                this.handle = this.delegate.getWriteThread().executeAfter(this.timeoutCommand, this.writeTimeout, TimeUnit.MILLISECONDS);
            } else if (ret > 0L && this.handle != null) {
                this.handle.remove();
            }
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int ret = this.delegate.write(src);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = this.delegate.write(srcs, offset, length);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        int ret = this.delegate.writeFinal(src);
        this.handleWriteTimeout(ret);
        if (!src.hasRemaining() && this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
        return ret;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = this.delegate.writeFinal(srcs, offset, length);
        this.handleWriteTimeout(ret);
        if (!Buffers.hasRemaining(srcs, offset, length) && this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
        return ret;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        long ret = this.delegate.writeFinal(srcs);
        this.handleWriteTimeout(ret);
        if (!Buffers.hasRemaining(srcs) && this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
        return ret;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long ret = this.delegate.transferFrom(src, position, count);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long ret = this.delegate.transferFrom(source, count, throughBuffer);
        this.handleWriteTimeout(ret);
        return ret;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        T ret = super.setOption(option, value);
        if (option == Options.WRITE_TIMEOUT) {
            this.writeTimeout = (Integer)value;
            if (this.handle != null) {
                this.handle.remove();
                if (this.writeTimeout > 0) {
                    this.getWriteThread().executeAfter(this.timeoutCommand, this.writeTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }
        return ret;
    }

    @Override
    public void shutdownWrites() throws IOException {
        super.shutdownWrites();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }
}

