/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.StreamSourceChannel;

public class ServletInputStreamImpl
extends ServletInputStream {
    private final HttpServletRequestImpl request;
    private final StreamSourceChannel channel;
    private final Pool<ByteBuffer> bufferPool;
    private volatile ReadListener listener;
    private volatile ServletInputStreamChannelListener internalListener;
    private static final int FLAG_READY = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_FINISHED = 4;
    private static final int FLAG_ON_DATA_READ_CALLED = 8;
    private int state;
    private AsyncContextImpl asyncContext;
    private Pooled<ByteBuffer> pooled;

    public ServletInputStreamImpl(HttpServletRequestImpl request) {
        this.request = request;
        this.channel = request.getExchange().isRequestChannelAvailable() ? request.getExchange().getRequestChannel() : new EmptyStreamSourceChannel(request.getExchange().getIoThread());
        this.bufferPool = request.getExchange().getConnection().getBufferPool();
    }

    @Override
    public boolean isFinished() {
        return Bits.anyAreSet(this.state, 4);
    }

    @Override
    public boolean isReady() {
        return Bits.anyAreSet(this.state, 1) && !this.isFinished();
    }

    @Override
    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        if (!this.request.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = this.request.getAsyncContext();
        this.listener = readListener;
        this.internalListener = new ServletInputStreamChannelListener();
        this.channel.getReadSetter().set(this.internalListener);
        this.asyncContext.addAsyncTask(new Runnable(){

            @Override
            public void run() {
                ServletInputStreamImpl.this.channel.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletInputStreamImpl.this.channel.resumeReads();
                        ServletInputStreamImpl.this.internalListener.handleEvent(ServletInputStreamImpl.this.channel);
                    }
                });
            }
        });
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener != null) {
            if (Bits.anyAreClear(this.state, 1)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
        } else {
            this.readIntoBuffer();
        }
        if (Bits.anyAreSet(this.state, 4)) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = this.pooled.getResource();
        int copied = Buffers.copy(ByteBuffer.wrap(b, off, len), buffer);
        if (!buffer.hasRemaining()) {
            this.pooled.free();
            this.pooled = null;
            if (this.listener != null) {
                this.readIntoBufferNonBlocking();
            }
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet(this.state, 4)) {
            this.pooled = this.bufferPool.allocate();
            int res = Channels.readBlocking(this.channel, this.pooled.getResource());
            this.pooled.getResource().flip();
            if (res == -1) {
                this.state |= 4;
                this.pooled.free();
                this.pooled = null;
            }
        }
    }

    private void readIntoBufferNonBlocking() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet(this.state, 4)) {
            this.pooled = this.bufferPool.allocate();
            if (this.listener == null) {
                int res = this.channel.read(this.pooled.getResource());
                if (res == 0) {
                    this.pooled.free();
                    this.pooled = null;
                    return;
                }
                this.pooled.getResource().flip();
                if (res == -1) {
                    this.state |= 4;
                    this.pooled.free();
                    this.pooled = null;
                }
            } else {
                if (Bits.anyAreClear(this.state, 1)) {
                    throw UndertowServletMessages.MESSAGES.streamNotReady();
                }
                int res = this.channel.read(this.pooled.getResource());
                this.pooled.getResource().flip();
                if (res == -1) {
                    this.state |= 4;
                    this.pooled.free();
                    this.pooled = null;
                } else if (res == 0) {
                    this.state &= 0xFFFFFFFE;
                    this.pooled.free();
                    this.pooled = null;
                    this.channel.getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!ServletInputStreamImpl.this.channel.isReadResumed()) {
                                ServletInputStreamImpl.this.channel.resumeReads();
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBufferNonBlocking();
        if (Bits.anyAreSet(this.state, 4)) {
            return 0;
        }
        if (this.pooled == null) {
            return 0;
        }
        return this.pooled.getResource().remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        this.state |= 2;
        try {
            while (Bits.allAreClear(this.state, 4)) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.free();
                this.pooled = null;
            }
        }
        finally {
            this.state |= 4;
            if (this.pooled != null) {
                this.pooled.free();
                this.pooled = null;
            }
            this.channel.shutdownReads();
        }
    }

    private class ServletInputStreamChannelListener
    implements ChannelListener<StreamSourceChannel> {
        private ServletInputStreamChannelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSourceChannel channel) {
            ThreadSetupAction.Handle handle;
            CompositeThreadSetupAction action;
            block17: {
                if (ServletInputStreamImpl.this.asyncContext.isDispatched()) {
                    channel.suspendReads();
                    return;
                }
                if (Bits.anyAreSet(ServletInputStreamImpl.this.state, 4)) {
                    channel.suspendReads();
                    return;
                }
                ServletInputStreamImpl.this.state |= 1;
                try {
                    ServletInputStreamImpl.this.readIntoBufferNonBlocking();
                    if (ServletInputStreamImpl.this.pooled == null) break block17;
                    ServletInputStreamImpl.this.state |= 1;
                    if (Bits.anyAreSet(ServletInputStreamImpl.this.state, 4)) break block17;
                    action = ServletInputStreamImpl.this.request.getServletContext().getDeployment().getThreadSetupAction();
                    handle = action.setup(ServletInputStreamImpl.this.request.getExchange());
                    try {
                        ServletInputStreamImpl.this.listener.onDataAvailable();
                    }
                    finally {
                        handle.tearDown();
                    }
                    if (ServletInputStreamImpl.this.pooled != null) {
                        channel.suspendReads();
                    }
                }
                catch (Exception e) {
                    CompositeThreadSetupAction action2 = ServletInputStreamImpl.this.request.getServletContext().getDeployment().getThreadSetupAction();
                    ThreadSetupAction.Handle handle2 = action2.setup(ServletInputStreamImpl.this.request.getExchange());
                    try {
                        ServletInputStreamImpl.this.listener.onError(e);
                    }
                    finally {
                        handle2.tearDown();
                    }
                    IoUtils.safeClose((Closeable)channel);
                }
            }
            if (Bits.anyAreSet(ServletInputStreamImpl.this.state, 4) && Bits.anyAreClear(ServletInputStreamImpl.this.state, 8)) {
                try {
                    ServletInputStreamImpl.this.state |= 8;
                    channel.shutdownReads();
                    action = ServletInputStreamImpl.this.request.getServletContext().getDeployment().getThreadSetupAction();
                    handle = action.setup(ServletInputStreamImpl.this.request.getExchange());
                    try {
                        ServletInputStreamImpl.this.listener.onAllDataRead();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
                catch (IOException e) {
                    ServletInputStreamImpl.this.listener.onError(e);
                    IoUtils.safeClose((Closeable)channel);
                }
            }
        }
    }
}

