/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.ajp.AjpOpenListener;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import io.undertow.server.protocol.spdy.SpdyOpenListener;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public final class Undertow {
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int ioThreads;
    private final int workerThreads;
    private final boolean directBuffers;
    private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
    private final HttpHandler rootHandler;
    private final OptionMap workerOptions;
    private final OptionMap socketOptions;
    private final OptionMap serverOptions;
    private XnioWorker worker;
    private List<AcceptingChannel<? extends StreamConnection>> channels;
    private Xnio xnio;

    private Undertow(Builder builder) {
        this.bufferSize = builder.bufferSize;
        this.buffersPerRegion = builder.buffersPerRegion;
        this.ioThreads = builder.ioThreads;
        this.workerThreads = builder.workerThreads;
        this.directBuffers = builder.directBuffers;
        this.listeners.addAll(builder.listeners);
        this.rootHandler = builder.handler;
        this.workerOptions = builder.workerOptions.getMap();
        this.socketOptions = builder.socketOptions.getMap();
        this.serverOptions = builder.serverOptions.getMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized void start() {
        this.xnio = Xnio.getInstance(Undertow.class.getClassLoader());
        this.channels = new ArrayList<AcceptingChannel<? extends StreamConnection>>();
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, this.workerThreads).set(Options.WORKER_TASK_MAX_THREADS, this.workerThreads).set(Options.TCP_NODELAY, true).set(Options.CORK, true).addAll(this.workerOptions).getMap());
            OptionMap socketOptions = OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).set(Options.BACKLOG, 1000).addAll(this.socketOptions).getMap();
            ByteBufferSlicePool buffers = new ByteBufferSlicePool(this.directBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, this.bufferSize, this.bufferSize * this.buffersPerRegion);
            for (ListenerConfig listener : this.listeners) {
                OpenListener openListener;
                HttpHandler rootHandler;
                HttpHandler httpHandler = rootHandler = listener.rootHandler != null ? listener.rootHandler : this.rootHandler;
                if (listener.type == ListenerType.AJP) {
                    AjpOpenListener openListener2 = new AjpOpenListener((Pool<ByteBuffer>)buffers, this.serverOptions);
                    openListener2.setRootHandler(rootHandler);
                    ChannelListener<AcceptingChannel<StreamConnection>> acceptListener = ChannelListeners.openListenerAdapter(openListener2);
                    AcceptingChannel<StreamConnection> server = this.worker.createStreamConnectionServer(new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, socketOptions);
                    server.resumeAccepts();
                    this.channels.add(server);
                    continue;
                }
                OptionMap undertowOptions = OptionMap.builder().set(UndertowOptions.BUFFER_PIPELINED_DATA, true).addAll(this.serverOptions).getMap();
                if (listener.type == ListenerType.HTTP) {
                    openListener = new HttpOpenListener((Pool<ByteBuffer>)buffers, undertowOptions);
                    openListener.setRootHandler(rootHandler);
                    ChannelListener<AcceptingChannel<StreamConnection>> acceptListener = ChannelListeners.openListenerAdapter(openListener);
                    AcceptingChannel<StreamConnection> server = this.worker.createStreamConnectionServer(new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, socketOptions);
                    server.resumeAccepts();
                    this.channels.add(server);
                    continue;
                }
                if (listener.type != ListenerType.HTTPS) continue;
                HttpOpenListener httpOpenListener = new HttpOpenListener((Pool<ByteBuffer>)buffers, undertowOptions);
                httpOpenListener.setRootHandler(rootHandler);
                boolean spdy = this.serverOptions.get(UndertowOptions.ENABLE_SPDY, false);
                boolean http2 = this.serverOptions.get(UndertowOptions.ENABLE_HTTP2, false);
                if (spdy || http2) {
                    AlpnOpenListener alpn = new AlpnOpenListener((Pool<ByteBuffer>)buffers, undertowOptions, (DelegateOpenListener)httpOpenListener);
                    if (spdy) {
                        SpdyOpenListener spdyListener = new SpdyOpenListener(buffers, new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, 1024, 1024), undertowOptions);
                        spdyListener.setRootHandler(rootHandler);
                        alpn.addProtocol("spdy/3.1", spdyListener, 5);
                    }
                    if (http2) {
                        Http2OpenListener http2Listener = new Http2OpenListener(buffers, undertowOptions);
                        http2Listener.setRootHandler(rootHandler);
                        alpn.addProtocol("h2", http2Listener, 10);
                        alpn.addProtocol("h2-14", http2Listener, 7);
                    }
                    openListener = alpn;
                } else {
                    openListener = httpOpenListener;
                }
                ChannelListener<AcceptingChannel<StreamConnection>> acceptListener = ChannelListeners.openListenerAdapter(openListener);
                XnioSsl xnioSsl = listener.sslContext != null ? new UndertowXnioSsl(this.xnio, OptionMap.create(Options.USE_DIRECT_BUFFERS, true), listener.sslContext) : this.xnio.getSslProvider(listener.keyManagers, listener.trustManagers, OptionMap.create(Options.USE_DIRECT_BUFFERS, true));
                AcceptingChannel<SslConnection> sslServer = xnioSsl.createSslConnectionServer(this.worker, new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, socketOptions);
                sslServer.resumeAccepts();
                this.channels.add(sslServer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void stop() {
        for (AcceptingChannel<? extends StreamConnection> channel : this.channels) {
            IoUtils.safeClose(channel);
        }
        this.channels = null;
        this.worker.shutdownNow();
        this.worker = null;
        this.xnio = null;
    }

    public static final class Builder {
        private int bufferSize;
        private int buffersPerRegion;
        private int ioThreads;
        private int workerThreads;
        private boolean directBuffers;
        private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        private HttpHandler handler;
        private final OptionMap.Builder workerOptions = OptionMap.builder();
        private final OptionMap.Builder socketOptions = OptionMap.builder();
        private final OptionMap.Builder serverOptions = OptionMap.builder();

        private Builder() {
            this.ioThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
            this.workerThreads = this.ioThreads * 8;
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory < 0x4000000L) {
                this.directBuffers = false;
                this.bufferSize = 512;
                this.buffersPerRegion = 10;
            } else if (maxMemory < 0x8000000L) {
                this.directBuffers = true;
                this.bufferSize = 1024;
                this.buffersPerRegion = 10;
            } else {
                this.directBuffers = true;
                this.bufferSize = 16384;
                this.buffersPerRegion = 20;
            }
        }

        public Undertow build() {
            return new Undertow(this);
        }

        @Deprecated
        public Builder addListener(int port, String host) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTP, port, host, null, null, null));
            return this;
        }

        @Deprecated
        public Builder addListener(int port, String host, ListenerType listenerType) {
            this.listeners.add(new ListenerConfig(listenerType, port, host, null, null, null));
            return this;
        }

        public Builder addHttpListener(int port, String host) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTP, port, host, null, null, null));
            return this;
        }

        public Builder addHttpsListener(int port, String host, KeyManager[] keyManagers, TrustManager[] trustManagers) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTPS, port, host, keyManagers, trustManagers, null));
            return this;
        }

        public Builder addHttpsListener(int port, String host, SSLContext sslContext) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTPS, port, host, sslContext, null));
            return this;
        }

        public Builder addAjpListener(int port, String host) {
            this.listeners.add(new ListenerConfig(ListenerType.AJP, port, host, null, null, null));
            return this;
        }

        public Builder addHttpListener(int port, String host, HttpHandler rootHandler) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTP, port, host, null, null, rootHandler));
            return this;
        }

        public Builder addHttpsListener(int port, String host, KeyManager[] keyManagers, TrustManager[] trustManagers, HttpHandler rootHandler) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTPS, port, host, keyManagers, trustManagers, rootHandler));
            return this;
        }

        public Builder addHttpsListener(int port, String host, SSLContext sslContext, HttpHandler rootHandler) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTPS, port, host, sslContext, rootHandler));
            return this;
        }

        public Builder addAjpListener(int port, String host, HttpHandler rootHandler) {
            this.listeners.add(new ListenerConfig(ListenerType.AJP, port, host, null, null, rootHandler));
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setBuffersPerRegion(int buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
            return this;
        }

        public Builder setIoThreads(int ioThreads) {
            this.ioThreads = ioThreads;
            return this;
        }

        public Builder setWorkerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        public Builder setDirectBuffers(boolean directBuffers) {
            this.directBuffers = directBuffers;
            return this;
        }

        public Builder setHandler(HttpHandler handler) {
            this.handler = handler;
            return this;
        }

        public <T> Builder setServerOption(Option<T> option, T value) {
            this.serverOptions.set(option, value);
            return this;
        }

        public <T> Builder setSocketOption(Option<T> option, T value) {
            this.socketOptions.set(option, value);
            return this;
        }

        public <T> Builder setWorkerOption(Option<T> option, T value) {
            this.workerOptions.set(option, value);
            return this;
        }
    }

    private static class ListenerConfig {
        final ListenerType type;
        final int port;
        final String host;
        final KeyManager[] keyManagers;
        final TrustManager[] trustManagers;
        final SSLContext sslContext;
        final HttpHandler rootHandler;

        private ListenerConfig(ListenerType type, int port, String host, KeyManager[] keyManagers, TrustManager[] trustManagers, HttpHandler rootHandler) {
            this.type = type;
            this.port = port;
            this.host = host;
            this.keyManagers = keyManagers;
            this.trustManagers = trustManagers;
            this.rootHandler = rootHandler;
            this.sslContext = null;
        }

        private ListenerConfig(ListenerType type, int port, String host, SSLContext sslContext, HttpHandler rootHandler) {
            this.type = type;
            this.port = port;
            this.host = host;
            this.rootHandler = rootHandler;
            this.keyManagers = null;
            this.trustManagers = null;
            this.sslContext = sslContext;
        }
    }

    public static enum ListenerType {
        HTTP,
        HTTPS,
        AJP;

    }
}

