/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xnio.IoUtils;
import org.xnio.Pooled;

public class PathResource
implements RangeAwareResource {
    private final Path file;
    private final String path;
    private final PathResourceManager manager;

    public PathResource(Path file, PathResourceManager manager, String path) {
        this.file = file;
        this.path = path;
        this.manager = manager;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Date getLastModified() {
        try {
            return new Date(Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getLastModifiedString() {
        return DateUtils.toDateString(this.getLastModified());
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getFileName().toString();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.file, new LinkOption[0]);
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.file);){
            for (Path child : stream) {
                resources.add(new PathResource(child, this.manager, this.path));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    @Override
    public void serve(Sender sender, HttpServerExchange exchange, IoCallback callback) {
        this.serveImpl(sender, exchange, -1L, -1L, callback, false);
    }

    @Override
    public void serveRange(Sender sender, HttpServerExchange exchange, long start, long end, IoCallback callback) {
        this.serveImpl(sender, exchange, start, end, callback, true);
    }

    private void serveImpl(final Sender sender, final HttpServerExchange exchange, final long start, final long end, final IoCallback callback, final boolean range) {
        abstract class BaseFileTask
        implements Runnable {
            protected volatile FileChannel fileChannel;
            final /* synthetic */ boolean val$range;
            final /* synthetic */ long val$start;
            final /* synthetic */ HttpServerExchange val$exchange;
            final /* synthetic */ IoCallback val$callback;
            final /* synthetic */ Sender val$sender;

            BaseFileTask() {
                this.val$range = bl;
                this.val$start = l;
                this.val$exchange = httpServerExchange;
                this.val$callback = ioCallback;
                this.val$sender = sender;
            }

            protected boolean openFile() {
                try {
                    this.fileChannel = FileChannel.open(PathResource.this.file, StandardOpenOption.READ);
                    if (this.val$range) {
                        this.fileChannel.position(this.val$start);
                    }
                }
                catch (NoSuchFileException e) {
                    this.val$exchange.setResponseCode(404);
                    this.val$callback.onException(this.val$exchange, this.val$sender, e);
                    return false;
                }
                catch (IOException e) {
                    this.val$exchange.setResponseCode(500);
                    this.val$callback.onException(this.val$exchange, this.val$sender, e);
                    return false;
                }
                return true;
            }
        }
        BaseFileTask task;
        try {
            class ServerTask
            extends BaseFileTask
            implements IoCallback {
                private Pooled<ByteBuffer> pooled;
                long remaining;

                ServerTask() {
                    super(PathResource.this, bl, l, httpServerExchange, ioCallback, sender2);
                    this.remaining = end - start + 1L;
                }

                @Override
                public void run() {
                    if (range && this.remaining == 0L) {
                        this.pooled.free();
                        this.pooled = null;
                        IoUtils.safeClose((Closeable)this.fileChannel);
                        callback.onComplete(exchange, sender);
                        return;
                    }
                    if (this.fileChannel == null) {
                        if (!this.openFile()) {
                            return;
                        }
                        this.pooled = exchange.getConnection().getBufferPool().allocate();
                    }
                    if (this.pooled != null) {
                        ByteBuffer buffer = this.pooled.getResource();
                        try {
                            buffer.clear();
                            int res = this.fileChannel.read(buffer);
                            if (res == -1) {
                                this.pooled.free();
                                IoUtils.safeClose((Closeable)this.fileChannel);
                                callback.onComplete(exchange, sender);
                                return;
                            }
                            buffer.flip();
                            if (range) {
                                if ((long)buffer.remaining() > this.remaining) {
                                    buffer.limit((int)((long)buffer.position() + this.remaining));
                                }
                                this.remaining -= (long)buffer.remaining();
                            }
                            sender.send(buffer, (IoCallback)this);
                        }
                        catch (IOException e) {
                            this.onException(exchange, sender, e);
                        }
                    }
                }

                @Override
                public void onComplete(HttpServerExchange exchange2, Sender sender2) {
                    if (exchange2.isInIoThread()) {
                        exchange2.dispatch(this);
                    } else {
                        this.run();
                    }
                }

                @Override
                public void onException(HttpServerExchange exchange2, Sender sender2, IOException exception) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                    if (this.pooled != null) {
                        this.pooled.free();
                        this.pooled = null;
                    }
                    IoUtils.safeClose((Closeable)this.fileChannel);
                    if (!exchange2.isResponseStarted()) {
                        exchange2.setResponseCode(500);
                    }
                    callback.onException(exchange2, sender2, exception);
                }
            }
            class TransferTask
            extends BaseFileTask {
                TransferTask() {
                    super(PathResource.this, bl, l, httpServerExchange, ioCallback, sender2);
                }

                @Override
                public void run() {
                    if (!this.openFile()) {
                        return;
                    }
                    sender.transferFrom(this.fileChannel, new IoCallback(){

                        @Override
                        public void onComplete(HttpServerExchange exchange, Sender sender) {
                            try {
                                IoUtils.safeClose((Closeable)fileChannel);
                            }
                            finally {
                                callback.onComplete(exchange, sender);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                            try {
                                IoUtils.safeClose((Closeable)fileChannel);
                            }
                            finally {
                                callback.onException(exchange, sender, exception);
                            }
                        }
                    });
                }
            }
            task = this.manager.getTransferMinSize() > Files.size(this.file) || range ? new ServerTask() : new TransferTask();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch(task);
        } else {
            task.run();
        }
    }

    @Override
    public Long getContentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCacheKey() {
        return this.file.toString();
    }

    @Override
    public File getFile() {
        return this.file.toFile();
    }

    @Override
    public Path getFilePath() {
        return this.file;
    }

    @Override
    public File getResourceManagerRoot() {
        return this.manager.getBasePath().toFile();
    }

    @Override
    public Path getResourceManagerRootPath() {
        return this.manager.getBasePath();
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRangeSupported() {
        return true;
    }
}

