/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.List;

public class ServletAuthenticationConstraintHandler
extends AuthenticationConstraintHandler {
    private final boolean formAuth;

    public ServletAuthenticationConstraintHandler(HttpHandler next, boolean formAuth) {
        super(next);
        this.formAuth = formAuth;
    }

    @Override
    protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
        if (this.formAuth && exchange.getRelativePath().endsWith("/j_security_check")) {
            return true;
        }
        List<SingleConstraintMatch> constraints = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getRequiredConstrains();
        boolean authenticationRequired = false;
        for (SingleConstraintMatch constraint : constraints) {
            if (constraint.getRequiredRoles().isEmpty()) {
                if (constraint.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.DENY) {
                    return false;
                }
                if (constraint.getEmptyRoleSemantic() != SecurityInfo.EmptyRoleSemantic.AUTHENTICATE) continue;
                authenticationRequired = true;
                continue;
            }
            authenticationRequired = true;
        }
        return authenticationRequired;
    }
}

