/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class QueryStringAttribute
implements ExchangeAttribute {
    public static final String QUERY_STRING_SHORT = "%q";
    public static final String QUERY_STRING = "%{QUERY_STRING}";
    public static final ExchangeAttribute INSTANCE = new QueryStringAttribute();

    private QueryStringAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        String qs = exchange.getQueryString();
        if (qs.isEmpty()) {
            return qs;
        }
        return '?' + qs;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setQueryString(newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Query String";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(QueryStringAttribute.QUERY_STRING) || token.equals(QueryStringAttribute.QUERY_STRING_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

